/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class MilkIngredient
extends AbstractIngredient {
    private ItemStack[] matchingStacks;
    public static final Codec<MilkIngredient> CODEC = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit((Object)((Object)new MilkIngredient()))).codec();
    public static final IIngredientSerializer<MilkIngredient> SERIALIZER = new IIngredientSerializer<MilkIngredient>(){

        public Codec<? extends MilkIngredient> codec() {
            return CODEC;
        }

        public MilkIngredient read(FriendlyByteBuf buffer) {
            return new MilkIngredient();
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull MilkIngredient ingredient) {
        }
    };

    public MilkIngredient() {
        super(Stream.of(new Ingredient.Value[0]));
    }

    public boolean test(ItemStack itemStack) {
        ItemStack container;
        Optional drainedFluidOptional;
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        if (itemStack.m_41720_() == Items.f_42455_) {
            return true;
        }
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (location != null && "mekanism".equals(location.m_135827_()) && itemStack.getCraftingRemainingItem().m_41619_()) {
            return false;
        }
        if (ForgeMod.MILK.isPresent() && (drainedFluidOptional = FluidUtil.getFluidHandler((ItemStack)(container = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1))).map(fluidHandler -> fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE))).isPresent() && !((FluidStack)drainedFluidOptional.get()).isEmpty()) {
            FluidStack drainedFluid = (FluidStack)drainedFluidOptional.get();
            return drainedFluid.getFluid() == ForgeMod.MILK.get() && drainedFluid.getAmount() == 1000;
        }
        return BucketLibUtil.containsMilk(itemStack.m_41777_());
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            stacks.add(new ItemStack((ItemLike)Items.f_42455_));
            BucketLibMod.getRegisteredBuckets().forEach(universalBucketItem -> {
                if (universalBucketItem.canMilkEntities()) {
                    stacks.add(BucketLibUtil.addMilk(new ItemStack((ItemLike)universalBucketItem)));
                }
            });
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return this.matchingStacks;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    public IIngredientSerializer<? extends Ingredient> serializer() {
        return SERIALIZER;
    }
}

