/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.item.crafting.BucketFillingType;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BucketFillingShapedRecipe
extends ShapedRecipe {
    private final CraftingBookCategory category;
    private final ShapedRecipePattern pattern;
    private final BucketFillingType fillingType;
    private final Fluid fluid;
    private final Block block;
    private final EntityType<?> entityType;

    public BucketFillingShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, BucketFillingType fillingType, Optional<Fluid> fluid, Optional<Block> block, Optional<EntityType<?>> entityType) {
        super(group, category, pattern, BucketFillingShapedRecipe.getAssembledBucket(fillingType, fluid.orElse(null), block.orElse(null), entityType.orElse(null), pattern.f_303265_().stream().map(ingredient -> Arrays.stream(ingredient.m_43908_()).toList()).flatMap(Collection::stream).toList()));
        this.category = category;
        this.pattern = pattern;
        this.fillingType = fillingType;
        this.fluid = fluid.orElse(null);
        this.block = block.orElse(null);
        this.entityType = entityType.orElse(null);
    }

    private static ItemStack getAffectedBucket(List<ItemStack> itemStacks) {
        for (ItemStack stack : itemStacks) {
            if (!(stack.m_41720_() instanceof UniversalBucketItem) || !BucketLibUtil.isEmpty(stack)) continue;
            ItemStack bucket = stack.m_41777_();
            bucket.m_41764_(1);
            return bucket;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getAssembledBucket(BucketFillingType fillingType, Fluid fluid, Block block, EntityType<?> entityType, List<ItemStack> itemStacks) {
        ItemStack bucket = BucketFillingShapedRecipe.getAffectedBucket(itemStacks);
        Item item = bucket.m_41720_();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem universalBucketItem = (UniversalBucketItem)item;
            if (fillingType == BucketFillingType.BLOCK && universalBucketItem.canHoldBlock(block)) {
                return BucketLibUtil.addBlock(bucket, block);
            }
            if (fillingType == BucketFillingType.ENTITY && universalBucketItem.canHoldEntity(entityType) && (fluid == null || universalBucketItem.canHoldFluid(fluid))) {
                if (fluid != null) {
                    bucket = BucketLibUtil.addFluid(bucket, fluid);
                }
                return BucketLibUtil.addEntityType(bucket, entityType);
            }
            if (fillingType == BucketFillingType.FLUID && universalBucketItem.canHoldFluid(fluid)) {
                return BucketLibUtil.addFluid(bucket, fluid);
            }
            if (fillingType == BucketFillingType.MILK && universalBucketItem.canMilkEntities()) {
                return BucketLibUtil.addMilk(bucket);
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5818_(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        ItemStack bucket = BucketFillingShapedRecipe.getAffectedBucket(inv.m_7086_());
        if (bucket == ItemStack.f_41583_) {
            return false;
        }
        UniversalBucketItem universalBucketItem = (UniversalBucketItem)bucket.m_41720_();
        return !(!super.m_5818_(inv, level) || this.fillingType == BucketFillingType.BLOCK && !universalBucketItem.canHoldBlock(this.block) || this.fillingType == BucketFillingType.ENTITY && (!universalBucketItem.canHoldEntity(this.entityType) || this.fluid != null && !universalBucketItem.canHoldFluid(this.fluid)) || this.fillingType == BucketFillingType.FLUID && !universalBucketItem.canHoldFluid(this.fluid) || this.fillingType == BucketFillingType.MILK && !universalBucketItem.canMilkEntities());
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess registryAccess) {
        return BucketFillingShapedRecipe.getAssembledBucket(this.fillingType, this.fluid, this.block, this.entityType, inv.m_7086_());
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<BucketFillingShapedRecipe> {
        public static final Codec<BucketFillingShapedRecipe> CODEC = RecordCodecBuilder.create(record -> record.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(ShapedRecipe::m_6076_), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)ShapedRecipePattern.f_302908_.forGetter(recipe -> recipe.pattern), (App)BucketFillingType.CODEC.fieldOf("filling_type").forGetter(recipe -> recipe.fillingType), (App)RegistryUtil.FLUID_CODEC.optionalFieldOf("fluid").forGetter(recipe -> Optional.of(recipe.fluid)), (App)RegistryUtil.BLOCK_CODEC.optionalFieldOf("block").forGetter(recipe -> Optional.of(recipe.block)), (App)RegistryUtil.ENTITY_TYPE_CODEC.optionalFieldOf("entity").forGetter(recipe -> Optional.of(recipe.entityType))).apply((Applicative)record, BucketFillingShapedRecipe::new));
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public Codec<BucketFillingShapedRecipe> m_292673_() {
            return CODEC;
        }

        @Nonnull
        public BucketFillingShapedRecipe fromNetwork(FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            ShapedRecipePattern pattern = ShapedRecipePattern.m_306640_((FriendlyByteBuf)buf);
            BucketFillingType fillingType = BucketFillingType.valueOf(buf.m_130277_());
            Optional<Object> fluid = Optional.empty();
            Optional<Block> block = Optional.empty();
            Optional<EntityType<?>> entityType = Optional.empty();
            if (fillingType == BucketFillingType.BLOCK) {
                block = Optional.of(Services.REGISTRY.getBlock(buf.m_130281_()));
            } else if (fillingType == BucketFillingType.ENTITY) {
                entityType = Optional.of(Services.REGISTRY.getEntityType(buf.m_130281_()));
                fluid = Optional.of(Services.REGISTRY.getFluid(buf.m_130281_()));
                if (fluid.get() == Fluids.f_76191_) {
                    fluid = Optional.empty();
                }
            } else if (fillingType == BucketFillingType.FLUID) {
                fluid = Optional.of(Services.REGISTRY.getFluid(buf.m_130281_()));
            }
            return new BucketFillingShapedRecipe(group, category, pattern, fillingType, fluid, block, entityType);
        }

        public void toNetwork(FriendlyByteBuf buf, BucketFillingShapedRecipe recipe) {
            buf.m_130070_(recipe.m_6076_());
            buf.m_130068_((Enum)recipe.category);
            recipe.pattern.m_307574_(buf);
            buf.m_130068_((Enum)recipe.fillingType);
            if (recipe.fillingType == BucketFillingType.BLOCK) {
                buf.m_130085_(Objects.requireNonNull(Services.REGISTRY.getBlockLocation(recipe.block)));
            } else if (recipe.fillingType == BucketFillingType.ENTITY) {
                buf.m_130085_(Objects.requireNonNull(Services.REGISTRY.getEntityTypeLocation(recipe.entityType)));
                buf.m_130085_(Objects.requireNonNull(Services.REGISTRY.getFluidLocation(recipe.fluid != null ? recipe.fluid : Fluids.f_76191_)));
            } else if (recipe.fillingType == BucketFillingType.FLUID) {
                buf.m_130085_(Services.REGISTRY.getFluidLocation(recipe.fluid));
            }
        }
    }
}

