/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.jei;

import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@JeiPlugin
public class ModJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("bucketlib", "jei_plugin");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registration) {
        for (Item item : Services.REGISTRY.getRegisteredBuckets()) {
            registration.useNbtForSubtypes(new Item[]{item});
        }
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        if (Services.CONFIG.isInfinityEnchantmentEnabled()) {
            IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
            EnchantmentInstance data = new EnchantmentInstance(Enchantments.f_44952_, Enchantments.f_44952_.m_6586_());
            ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
            for (UniversalBucketItem bucketItem : Services.REGISTRY.getRegisteredBuckets()) {
                for (Fluid fluid : Services.REGISTRY.getAllFluids()) {
                    if (fluid == Fluids.f_76191_ || !bucketItem.canHoldFluid(fluid) || !fluid.m_76145_().m_205070_(BucketLibTags.Fluids.INFINITY_ENCHANTABLE)) continue;
                    ItemStack bucket = BucketLibUtil.addFluid(new ItemStack((ItemLike)bucketItem), fluid);
                    ItemStack enchantedBucket = bucket.m_41777_();
                    enchantedBucket.m_41663_(data.f_44947_, data.f_44948_);
                    recipes.add(factory.createAnvilRecipe(bucket, Collections.singletonList(EnchantedBookItem.m_41161_((EnchantmentInstance)data)), Collections.singletonList(enchantedBucket)));
                }
            }
            if (!recipes.isEmpty()) {
                registration.addRecipes(RecipeTypes.ANVIL, recipes);
            }
        }
    }
}

