/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxolotlAi.class})
public class AxolotlAiMixin {
    @Unique
    private static Ingredient bucketLib$axolotlTemptations = null;

    @Inject(at={@At(value="RETURN")}, method={"getTemptations"}, cancellable=true)
    private static void getTemptationsProxy(CallbackInfoReturnable<Ingredient> cir) {
        if (bucketLib$axolotlTemptations == null) {
            ArrayList<ItemStack> temptationStacks = new ArrayList<ItemStack>();
            for (ItemStack stack : ((Ingredient)cir.getReturnValue()).m_43908_()) {
                temptationStacks.add(stack);
                Item item = stack.m_41720_();
                if (!(item instanceof MobBucketItem)) continue;
                MobBucketItem mobBucketItem = (MobBucketItem)item;
                Fluid fluid = Services.BUCKET.getFluidOfBucketItem((BucketItem)mobBucketItem);
                EntityType<?> entityType = Services.BUCKET.getEntityTypeOfMobBucketItem(mobBucketItem);
                for (UniversalBucketItem bucketItem : Services.REGISTRY.getRegisteredBuckets()) {
                    if (!bucketItem.canHoldFluid(fluid) || !bucketItem.canHoldEntity(entityType)) continue;
                    ItemStack bucket = new ItemStack((ItemLike)bucketItem);
                    bucket = BucketLibUtil.addFluid(bucket, fluid);
                    bucket = BucketLibUtil.addEntityType(bucket, entityType);
                    temptationStacks.add(bucket);
                }
            }
            bucketLib$axolotlTemptations = Ingredient.m_43921_(temptationStacks.stream());
        }
        cir.setReturnValue((Object)bucketLib$axolotlTemptations);
    }
}

