/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.item.UniversalBucketFluidHandler;
import de.cech12.bucketlib.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={UniversalBucketItem.class}, remap=false)
public class ForgeUniversalBucketItemMixin
extends Item {
    public ForgeUniversalBucketItemMixin(Item.Properties properties) {
        super(properties);
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        Item item = itemStack.m_41720_();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem universalBucketItem = (UniversalBucketItem)item;
            return universalBucketItem.getBucketBurnTime(itemStack, recipeType);
        }
        return super.getBurnTime(itemStack, recipeType);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44952_ && Services.CONFIG.isInfinityEnchantmentEnabled() && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)stack) <= 0 && Services.FLUID.getContainedFluid(stack).m_76145_().m_205070_(BucketLibTags.Fluids.INFINITY_ENCHANTABLE)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new UniversalBucketFluidHandler(stack);
    }
}

