/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class ItemMixin {
    @Unique
    private boolean bucketLib$isUniversalBucket() {
        return this instanceof UniversalBucketItem;
    }

    @Unique
    private int bucketLib$getDurability() {
        ItemMixin itemMixin = this;
        if (itemMixin instanceof UniversalBucketItem) {
            UniversalBucketItem bucketItem = (UniversalBucketItem)((Object)itemMixin);
            return bucketItem.getDurability();
        }
        return ((Item)this).m_41462_();
    }

    @Inject(at={@At(value="HEAD")}, method={"getMaxDamage"}, cancellable=true)
    public void getMaxDamageProxy(CallbackInfoReturnable<Integer> cir) {
        if (this.bucketLib$isUniversalBucket()) {
            cir.setReturnValue((Object)this.bucketLib$getDurability());
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canBeDepleted"}, cancellable=true)
    public void canBeDepletedProxy(CallbackInfoReturnable<Boolean> cir) {
        if (this.bucketLib$isUniversalBucket()) {
            cir.setReturnValue((Object)(this.bucketLib$getDurability() > 0 ? 1 : 0));
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getBarWidth"}, cancellable=true)
    public void getBarWidthProxy(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (this.bucketLib$isUniversalBucket()) {
            cir.setReturnValue((Object)Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)this.bucketLib$getDurability()));
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getBarColor"}, cancellable=true)
    public void getBarColorProxy(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (this.bucketLib$isUniversalBucket()) {
            int durability = this.bucketLib$getDurability();
            float x = Math.max(0.0f, ((float)durability - (float)stack.m_41773_()) / (float)durability);
            cir.setReturnValue((Object)Mth.m_14169_((float)(x / 3.0f), (float)1.0f, (float)1.0f));
            cir.cancel();
        }
    }
}

