/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.platform;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import de.cech12.bucketlib.platform.services.IConfigHelper;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ForgeConfigHelper
implements IConfigHelper {
    private static final ForgeConfigSpec SERVER_CONFIG;
    public static final ForgeConfigSpec.BooleanValue INFINITY_ENCHANTMENT_ENABLED;

    @Override
    public void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
        Path path = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("bucketlib-server.toml");
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        SERVER_CONFIG.setConfig((CommentedConfig)configData);
    }

    @Override
    public boolean isInfinityEnchantmentEnabled() {
        try {
            return (Boolean)INFINITY_ENCHANTMENT_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return false;
        }
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Balance Options");
        INFINITY_ENCHANTMENT_ENABLED = builder.comment(INFINITY_ENCHANTMENT_ENABLED_DESCRIPTION).define("infinityEnchantmentEnabled", false);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

