/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.util;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;

public class ColorUtil {
    private ColorUtil() {
    }

    public static int getColorFromRGB(int red, int green, int blue) {
        int rgb = Math.max(Math.min(255, red), 0);
        rgb = (rgb << 8) + Math.max(Math.min(255, green), 0);
        rgb = (rgb << 8) + Math.max(Math.min(255, blue), 0);
        return rgb;
    }

    public static boolean hasColor(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41737_("display");
        return compoundTag != null && compoundTag.m_128425_("color", 99);
    }

    public static int getColor(ItemStack stack) {
        return ColorUtil.getColor(stack, 0);
    }

    public static int getColor(ItemStack stack, int defaultColor) {
        CompoundTag compoundTag = stack.m_41737_("display");
        return compoundTag != null && compoundTag.m_128425_("color", 99) ? compoundTag.m_128451_("color") : defaultColor;
    }

    public static void removeColor(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41737_("display");
        if (compoundTag != null && compoundTag.m_128441_("color")) {
            compoundTag.m_128473_("color");
        }
    }

    public static void setColor(ItemStack stack, int color) {
        stack.m_41698_("display").m_128405_("color", color);
    }

    public static ItemStack dyeItem(ItemStack stack, List<DyeItem> dyes) {
        int[] color = new int[3];
        int i = 0;
        int j = 0;
        ItemStack resultStack = stack.m_41777_();
        resultStack.m_41764_(1);
        if (ColorUtil.hasColor(stack)) {
            int k = ColorUtil.getColor(resultStack);
            float f = (float)(k >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(k & 0xFF) / 255.0f;
            i = (int)((float)i + Math.max(f, Math.max(f1, f2)) * 255.0f);
            color[0] = (int)((float)color[0] + f * 255.0f);
            color[1] = (int)((float)color[1] + f1 * 255.0f);
            color[2] = (int)((float)color[2] + f2 * 255.0f);
            ++j;
        }
        for (DyeItem dyeitem : dyes) {
            float[] afloat = dyeitem.m_41089_().m_41068_();
            int i2 = (int)(afloat[0] * 255.0f);
            int l = (int)(afloat[1] * 255.0f);
            int i1 = (int)(afloat[2] * 255.0f);
            i += Math.max(i2, Math.max(l, i1));
            color[0] = color[0] + i2;
            color[1] = color[1] + l;
            color[2] = color[2] + i1;
            ++j;
        }
        int j1 = color[0] / j;
        int k1 = color[1] / j;
        int l1 = color[2] / j;
        float f3 = (float)i / (float)j;
        float f4 = Math.max(j1, Math.max(k1, l1));
        j1 = (int)((float)j1 * f3 / f4);
        k1 = (int)((float)k1 * f3 / f4);
        l1 = (int)((float)l1 * f3 / f4);
        int j2 = (j1 << 8) + k1;
        j2 = (j2 << 8) + l1;
        ColorUtil.setColor(resultStack, j2);
        return resultStack;
    }
}

