/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import de.cech12.bucketlib.platform.Services;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class RegistryUtil {
    public static Codec<Fluid> FLUID_CODEC = Codec.of((Encoder)new Encoder<Fluid>(){

        public <T> DataResult<T> encode(Fluid input, DynamicOps<T> ops, T prefix) {
            return ops.mergeToPrimitive(prefix, ops.createString(Services.REGISTRY.getFluidLocation(input).toString()));
        }
    }, (Decoder)new Decoder<Fluid>(){

        public <T> DataResult<Pair<Fluid, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)Pair.of((Object)Services.REGISTRY.getFluid(new ResourceLocation((String)ops.getStringValue(input).get().left().get())), (Object)ops.empty()));
        }
    });
    public static Codec<Block> BLOCK_CODEC = Codec.of((Encoder)new Encoder<Block>(){

        public <T> DataResult<T> encode(Block input, DynamicOps<T> ops, T prefix) {
            return ops.mergeToPrimitive(prefix, ops.createString(Services.REGISTRY.getBlockLocation(input).toString()));
        }
    }, (Decoder)new Decoder<Block>(){

        public <T> DataResult<Pair<Block, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)Pair.of((Object)Services.REGISTRY.getBlock(new ResourceLocation((String)ops.getStringValue(input).get().left().get())), (Object)ops.empty()));
        }
    });
    public static Codec<EntityType<?>> ENTITY_TYPE_CODEC = Codec.of((Encoder)new Encoder<EntityType<?>>(){

        public <T> DataResult<T> encode(EntityType<?> input, DynamicOps<T> ops, T prefix) {
            return ops.mergeToPrimitive(prefix, ops.createString(Services.REGISTRY.getEntityTypeLocation(input).toString()));
        }
    }, (Decoder)new Decoder<EntityType<?>>(){

        public <T> DataResult<Pair<EntityType<?>, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)Pair.of(Services.REGISTRY.getEntityType(new ResourceLocation((String)ops.getStringValue(input).get().left().get())), (Object)ops.empty()));
        }
    });
    private static List<BucketBlock> bucketBlocks;
    private static List<BucketEntity> bucketEntities;

    private RegistryUtil() {
    }

    private static void readRegistry() {
        bucketBlocks = new ArrayList<BucketBlock>();
        bucketEntities = new ArrayList<BucketEntity>();
        Level level = Services.PLATFORM.getCurrentLevel();
        for (Item item : Services.REGISTRY.getAllItems()) {
            EntityType<?> entityType;
            SolidBucketItem bucket;
            if (item instanceof SolidBucketItem) {
                bucket = (SolidBucketItem)item;
                if (bucketBlocks.stream().noneMatch(bucketBlock -> bucketBlock.block == bucket.m_40614_())) {
                    bucketBlocks.add(new BucketBlock(bucket.m_40614_(), bucket));
                }
            }
            if (!(item instanceof MobBucketItem) || (entityType = Services.BUCKET.getEntityTypeOfMobBucketItem((MobBucketItem)(bucket = (MobBucketItem)item))) == null || level == null || !(entityType.m_20615_(level) instanceof Bucketable) || !bucketEntities.stream().noneMatch(bucketEntity -> bucketEntity.entityType == entityType)) continue;
            bucketEntities.add(new BucketEntity(entityType, Services.BUCKET.getFluidOfBucketItem((BucketItem)bucket), (MobBucketItem)bucket));
        }
    }

    public static List<BucketBlock> getBucketBlocks() {
        if (bucketBlocks == null) {
            RegistryUtil.readRegistry();
        }
        return bucketBlocks;
    }

    public static BucketBlock getBucketBlock(Block block) {
        for (BucketBlock bucketBlock : RegistryUtil.getBucketBlocks()) {
            if (bucketBlock.block() != block) continue;
            return bucketBlock;
        }
        return null;
    }

    public static List<BucketEntity> getBucketEntities() {
        if (bucketEntities == null) {
            RegistryUtil.readRegistry();
        }
        return bucketEntities;
    }

    public static BucketEntity getBucketEntity(EntityType<?> entityType) {
        for (BucketEntity bucketEntity : RegistryUtil.getBucketEntities()) {
            if (bucketEntity.entityType() != entityType) continue;
            return bucketEntity;
        }
        return null;
    }

    public record BucketBlock(Block block, SolidBucketItem bucketItem) {
    }

    public record BucketEntity(EntityType<?> entityType, Fluid fluid, MobBucketItem bucketItem) {
    }
}

