package de.cech12.bucketlib.api.crafting;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BlockIngredient implements CustomIngredient {

    protected final class_2248 block;
    protected final class_6862<class_2248> tag;
    private List<class_1799> matchingStacks;

    private BlockIngredient(class_2248 block, class_6862<class_2248> tag) {
        this.block = block;
        this.tag = tag;
    }

    public BlockIngredient(Optional<class_2960> blockOptional, Optional<class_6862<class_2248>> tagOptional) {
        this(blockOptional.map(class_7923.field_41175::method_10223).orElse(null), tagOptional.orElse(null));
    }

    public BlockIngredient(class_2248 block) {
        this(block, null);
    }

    public BlockIngredient(class_6862<class_2248> tag) {
        this(null, tag);
    }

    @Override
    public boolean test(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return false;
        }
        List<RegistryUtil.BucketBlock> bucketBlocks;
        if (this.block != null) {
            RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(this.block);
            if (bucketBlock == null) {
                return false;
            }
            bucketBlocks = List.of(bucketBlock);
        } else {
            bucketBlocks = RegistryUtil.getBucketBlocks().stream().filter(bucketBlock -> bucketBlock.block().method_9564().method_26164(this.tag)).toList();
        }
        for (RegistryUtil.BucketBlock bucketBlock : bucketBlocks) {
            if (itemStack.method_7909() == bucketBlock.bucketItem()) {
                return true;
            }
            return BucketLibUtil.getBlock(itemStack) == bucketBlock.block();
        }
        return false;
    }

    @Override
    public List<class_1799> getMatchingStacks() {
        if (this.matchingStacks == null) {
            this.matchingStacks = new ArrayList<>();
            List<class_2248> blocks = new ArrayList<>();
            Optional<class_6885.class_6888<class_2248>> blockTag = Optional.empty();
            if (this.tag != null) {
                blockTag = class_7923.field_41175.method_40266(this.tag);
            }
            if (blockTag.isPresent()) {
                blockTag.get().forEach(block -> blocks.add(block.comp_349()));
            } else if (this.block != null) {
                blocks.add(this.block);
            }
            List<RegistryUtil.BucketBlock> bucketBlocks = RegistryUtil.getBucketBlocks().stream().filter(bucketBlock -> blocks.contains(bucketBlock.block())).toList();
            //vanilla buckets
            for (RegistryUtil.BucketBlock bucketBlock : bucketBlocks) {
                this.matchingStacks.add(new class_1799(bucketBlock.bucketItem()));
            }
            //bucket lib buckets
            for (RegistryUtil.BucketBlock bucketBlock : bucketBlocks) {
                BucketLibMod.getRegisteredBuckets().forEach(bucket -> {
                    if (bucket.canHoldBlock(bucketBlock.block())) {
                        this.matchingStacks.add(BucketLibUtil.addBlock(new class_1799(bucket), bucketBlock.block()));
                    }
                });
            }
        }
        return this.matchingStacks;
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer implements CustomIngredientSerializer<BlockIngredient> {

        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 NAME = BucketLib.id("block");

        private static final MapCodec<BlockIngredient> CODEC = RecordCodecBuilder.mapCodec(builder ->
                builder.group(
                        class_2960.field_25139.optionalFieldOf("block").forGetter(i -> Optional.of(class_7923.field_41175.method_10221(i.block))),
                        class_6862.method_40090(class_7923.field_41175.method_30517()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))
                ).apply(builder, BlockIngredient::new)
        );

        private static final class_9139<class_9129, BlockIngredient> PACKET_CODEC = class_9139.method_56437(
                de.cech12.bucketlib.api.crafting.BlockIngredient.Serializer::write,
                de.cech12.bucketlib.api.crafting.BlockIngredient.Serializer::read);

        private Serializer() {}

        @Override
        public class_2960 getIdentifier() {
            return NAME;
        }

        @Override
        public MapCodec<BlockIngredient> getCodec(boolean allowEmpty) {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, BlockIngredient> getPacketCodec() {
            return PACKET_CODEC;
        }

        private static BlockIngredient read(class_9129 buffer) {
            String block = buffer.method_19772();
            String tagId = buffer.method_19772();
            if (!tagId.isEmpty()) {
                class_6862<class_2248> tag = class_6862.method_40092(class_7924.field_41254, class_2960.method_60654(tagId));
                return new BlockIngredient(tag);
            }
            if (block.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a block ingredient with no block or tag.");
            }
            return new BlockIngredient(class_7923.field_41175.method_10223(class_2960.method_60654(block)));
        }

        private static void write(@Nonnull class_9129 buffer, @Nonnull BlockIngredient ingredient) {
            buffer.method_10814(ingredient.block != null ? Objects.requireNonNull(class_7923.field_41175.method_10221(ingredient.block)).toString() : "");
            buffer.method_10814(ingredient.tag != null ? ingredient.tag.comp_327().toString() : "");
        }
    }

}
