package de.cech12.bucketlib.api.item;

import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.ItemStackUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import de.cech12.bucketlib.util.WorldInteractionUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1755;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1805;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3483;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_3956;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5761;
import net.minecraft.class_6862;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public class UniversalBucketItem extends class_1792 {

    private final Properties properties;

    public UniversalBucketItem(Properties properties) {
        super((new class_1792.class_1793().method_7889(1)));
        this.properties = properties;
    }

    @Override
    @Nonnull
    public class_2561 method_7864(@Nonnull class_1799 stack) {
        String descriptionId = this.method_7866(stack);
        class_2561 argument;
        if (BucketLibUtil.containsEntityType(stack)) {
            descriptionId += ".entity";
            class_1299<?> entityType = BucketLibUtil.getEntityType(stack);
            argument = (entityType != null) ? entityType.method_5897() : class_2561.method_43470("?");
        } else if (BucketLibUtil.containsFluid(stack)) {
            descriptionId += ".filled";
            class_3611 fluid = BucketLibUtil.getFluid(stack);
            argument = Services.FLUID.getFluidDescription(fluid);
        } else if (BucketLibUtil.containsBlock(stack)) {
            descriptionId += ".filled";
            class_2248 block = BucketLibUtil.getBlock(stack);
            argument = (block != null) ? block.method_9518() : class_2561.method_43470("?");
        } else if (BucketLibUtil.containsMilk(stack)) {
            descriptionId += ".filled";
            argument = class_2561.method_43471(Services.PLATFORM.getMilkTranslationKey());
        } else {
            //is empty
            return class_2561.method_43471(descriptionId);
        }
        return class_2561.method_43469(descriptionId, argument);
    }

    public boolean isCracked(class_1799 stack) {
        class_3611 fluid = BucketLibUtil.getFluid(stack);
        if (fluid != class_3612.field_15906) {
            int fluidTemperature = Services.FLUID.getFluidTemperature(fluid);
            Integer upperCrackingTemperature = getUpperBreakTemperature();
            Integer lowerCrackingTemperature = getLowerBreakTemperature();
            return isCrackingFluid(fluid)
                    || (upperCrackingTemperature != null && fluidTemperature >= upperCrackingTemperature)
                    || (lowerCrackingTemperature != null && fluidTemperature <= lowerCrackingTemperature)
                    && !BucketLibUtil.isAffectedByInfinityEnchantment(stack);
        }
        return false;
    }

    public boolean canHoldFluid(class_3611 fluid) {
        if (fluid == class_3612.field_15906) {
            return true;
        }
        class_1792 bucket;
        try {
            bucket = fluid.method_15774();
        } catch (IllegalArgumentException ex) {
            //workaround to avoid game crash caused by getBucket() method of "noBucket" fluids of Registrate (tterrag1098) mod: https://github.com/tterrag1098/Registrate/issues/69
            BucketLib.LOG.error("IllegalArgumentException occurred while trying to get the bucket item of fluid '" + Services.FLUID.getFluidDescription(fluid) + "' [fluid.getBucket()]. BucketLib is not compatible with this fluid. Please contact the mod developer of the mod which adds this fluid!", ex);
            return false;
        }
        if (bucket instanceof class_1805 && fluid != Services.FLUID.getMilkFluid()) {
            return false;
        }
        if (!(bucket instanceof class_1805) && (!(bucket instanceof class_1755) || Services.BUCKET.getFluidOfBucketItem((class_1755) bucket) != fluid)) {
            return false;
        }
        if (this.properties.allowedFluidsTag != null || this.properties.allowedFluids != null) {
            return isAllowedFluid(fluid);
        }
        if (this.properties.deniedFluidsTag != null || this.properties.deniedFluids != null) {
            return !isDeniedFluid(fluid);
        }
        int fluidTemperature = Services.FLUID.getFluidTemperature(fluid);
        Integer maxTemperature = getMaxTemperature();
        Integer minTemperature = getMinTemperature();
        return (maxTemperature == null || fluidTemperature <= maxTemperature)
                && (minTemperature == null || fluidTemperature >= minTemperature);
    }

    public boolean canHoldEntity(class_1299<?> entityType) {
        if (this.canObtainEntities()) {
            if (this.properties.allowedEntitiesTag != null || this.properties.allowedEntities != null) {
                return isAllowedEntity(entityType);
            }
            if (this.properties.deniedEntitiesTag != null || this.properties.deniedEntities != null) {
                return !isDeniedEntity(entityType);
            }
            return true;
        }
        return false;
    }

    public boolean canHoldBlock(class_2248 block) {
        if (this.canObtainBlocks()) {
            if (this.properties.allowedBlocksTag != null || this.properties.allowedBlocks != null) {
                return isAllowedBlock(block);
            }
            if (this.properties.deniedBlocksTag != null || this.properties.deniedBlocks != null) {
                return !isDeniedBlock(block);
            }
            return true;
        }
        return false;
    }

    //@Override //overrides the neoforge implementation //used by mixin
    public int getMaxStackSize(class_1799 stack) {
        return BucketLibUtil.isEmpty(stack) ? this.properties.maxStackSize : 1;
    }

    //used by mixins
    public int getBucketBurnTime(class_1799 stack, class_3956<?> recipeType) {
        //entity buckets should not use the burn time of its fluid
        if (stack.method_7909() instanceof UniversalBucketItem && !BucketLibUtil.containsEntityType(stack)) {
            class_3611 fluid = Services.FLUID.getContainedFluid(stack);
            if (fluid != class_3612.field_15906) {
                return Services.PLATFORM.getBurnTime(new class_1799(fluid.method_15774()), recipeType);
            }
        }
        return 0; //don't call Services.PLATFORM.getBurnTime() to avoid recursive calls
    }

    @Override
    public void method_7888(@Nonnull class_1799 itemStack, @Nonnull class_1937 level, @Nonnull class_1297 entity, int position, boolean selected) {
        if (!level.field_9236) {
            if (!entity.method_5753() && this.hasBurningContent(itemStack)) {
                entity.method_32317(0); //avoid extinguish sounds
                entity.method_20803(100);
                if (BucketLibUtil.notCreative(entity) && entity.field_6012 % 20 == 0) {
                    BucketLibUtil.damageByOne(itemStack, (class_3218) level, (entity instanceof class_1657) ? (class_1657) entity : null);
                }
            } else if (!entity.method_5809() && entity.method_32316() && this.hasFreezingContent(itemStack)) {
                int ticks = entity.method_32312() + (entity.field_27857 ? 1 : 3); //2 are subtracted when not in powder snow
                entity.method_32317(Math.min(entity.method_32315(), ticks));
                //damaging here because, the vanilla mechanic is reducing the freeze ticks below fully freezing
                if (BucketLibUtil.notCreative(entity) && entity.field_6012 % 40 == 0 && entity.method_32314()) {
                    entity.method_5643(level.method_48963().method_48836(), entity.method_5864().method_20210(class_3483.field_29826) ? 5 : 1);
                    BucketLibUtil.damageByOne(itemStack, (class_3218) level, (entity instanceof class_1657) ? (class_1657) entity : null);
                }
            }
        }
    }

    private boolean hasBurningContent(@Nonnull class_1799 itemStack) {
        Integer burningTemperature = this.getBurningTemperature();
        class_3611 fluid = BucketLibUtil.getFluid(itemStack);
        return fluid != class_3612.field_15906 && (burningTemperature != null && Services.FLUID.getFluidTemperature(fluid) >= burningTemperature || this.isBurningFluid(fluid))
                || this.isBurningBlock(BucketLibUtil.getBlock(itemStack));
    }

    private boolean hasFreezingContent(@Nonnull class_1799 itemStack) {
        Integer freezingTemperature = this.getFreezingTemperature();
        class_3611 fluid = BucketLibUtil.getFluid(itemStack);
        return fluid != class_3612.field_15906 && (freezingTemperature != null && Services.FLUID.getFluidTemperature(fluid) <= freezingTemperature || this.isFreezingFluid(fluid))
                || this.isFreezingBlock(BucketLibUtil.getBlock(itemStack));
    }

    @Override
    @Nonnull
    public class_1271<class_1799> method_7836(@Nonnull class_1937 level, @Nonnull class_1657 player, @Nonnull class_1268 interactionHand) {
        class_1799 itemstack = player.method_5998(interactionHand);
        boolean isEmpty = BucketLibUtil.isEmpty(itemstack);
        //check hit block
        class_3965 blockHitResult = method_7872(level, player, isEmpty ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348);
        if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 hitBlockPos = blockHitResult.method_17777();
            class_2680 hitBlockState = level.method_8320(hitBlockPos);
            class_2350 hitDirection = blockHitResult.method_17780();
            class_2338 relativeBlockPos = hitBlockPos.method_10093(hitDirection);
            class_3218 serverLevel = (level instanceof class_3218) ? (class_3218) level : null;
            if (isEmpty) {
                //pickup from cauldron interaction
                class_1271<class_1799> caldronInteractionResult = WorldInteractionUtil.tryPickupFromCauldron(level, player, interactionHand, blockHitResult);
                if (caldronInteractionResult.method_5467().method_23665()) {
                    return caldronInteractionResult;
                }
                class_3545<Boolean, class_1799> result = Services.FLUID.tryPickUpFluid(BucketLibUtil.removeEntityData(itemstack, serverLevel, player, false), player, level, interactionHand, hitBlockPos, hitDirection);
                if (result.method_15442()) {
                    return class_1271.method_29237(class_5328.method_30012(itemstack, player, result.method_15441()), level.method_8608());
                }
                //pickup block interaction
                RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(hitBlockState.method_26204());
                if (bucketBlock != null && canHoldBlock(bucketBlock.block())) {
                    //fake vanilla bucket use
                    class_1799 fakeStack = new class_1799(class_1802.field_8550);
                    player.method_6122(interactionHand, fakeStack);
                    class_1271<class_1799> interactionResult = fakeStack.method_7913(level, player, interactionHand);
                    player.method_6122(interactionHand, itemstack);
                    if (interactionResult.method_5467().method_23665()) {
                        return new class_1271<>(interactionResult.method_5467(), class_5328.method_30012(itemstack.method_7972(), player, BucketLibUtil.addBlock(ItemStackUtil.copyStackWithSize(itemstack, 1), bucketBlock.block())));
                    }
                }
            } else {
                //place into cauldron interaction
                class_1271<class_1799> caldronInteractionResult = WorldInteractionUtil.tryPlaceIntoCauldron(level, player, interactionHand, blockHitResult);
                if (caldronInteractionResult.method_5467().method_23665()) {
                    return caldronInteractionResult;
                }
                if (BucketLibUtil.containsFluid(itemstack)) {
                    //try to place fluid at hit block and then at the relative block
                    for (class_2338 pos : Arrays.asList(hitBlockPos, relativeBlockPos)) {
                        //remove entity to be able to use tryPlaceFluid method
                        class_3545<Boolean, class_1799> result = Services.FLUID.tryPlaceFluid(BucketLibUtil.removeEntityData(itemstack, serverLevel, player, false), player, level, interactionHand, pos);
                        if (result.method_15442()) {
                            if (BucketLibUtil.containsEntityType(itemstack)) {
                                //place entity if exists
                                spawnEntityFromBucket(player, level, itemstack, pos, false);
                            }
                            return class_1271.method_29237(BucketLibUtil.createEmptyResult(itemstack, player, result.method_15441(), interactionHand), level.method_8608());
                        }
                    }
                } else if (BucketLibUtil.containsEntityType(itemstack)) {
                    //place entity interaction
                    class_1799 emptyBucket = spawnEntityFromBucket(player, level, itemstack, relativeBlockPos, true);
                    return class_1271.method_29237(BucketLibUtil.createEmptyResult(itemstack, player, emptyBucket, interactionHand), level.method_8608());
                } else if (BucketLibUtil.containsBlock(itemstack)) {
                    //place block interaction
                    class_2248 block = BucketLibUtil.getBlock(itemstack);
                    RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(block);
                    if (block != null && bucketBlock != null) {
                        //fake vanilla bucket use
                        class_1799 fakeStack = new class_1799(bucketBlock.bucketItem());
                        player.method_6122(interactionHand, fakeStack);
                        class_1269 interactionResult = fakeStack.method_7981(new class_1838(player, interactionHand, blockHitResult));
                        player.method_6122(interactionHand, itemstack);
                        if (interactionResult.method_23665()) {
                            return new class_1271<>(interactionResult, BucketLibUtil.createEmptyResult(itemstack, player, BucketLibUtil.removeBlock(itemstack, serverLevel, player, true), interactionHand));
                        }
                    }
                }
            }
        }
        if (BucketLibUtil.containsMilk(itemstack)) {
            return class_5328.method_29282(level, player, interactionHand);
        }
        return class_1271.method_22430(itemstack);
    }

    public class_1799 spawnEntityFromBucket(@Nullable class_1657 player, class_1937 level, class_1799 itemStack, class_2338 pos, boolean damage) {
        if (level instanceof class_3218 serverLevel) {
            class_1299<?> entityType = BucketLibUtil.getEntityType(itemStack);
            if (entityType != null) {
                class_1297 entity = entityType.method_5894(serverLevel, itemStack, null, pos, class_3730.field_16473, true, false);
                if (entity instanceof class_5761 bucketable) {
                    class_9279 customdata = itemStack.method_57825(class_9334.field_49610, class_9279.field_49302);
                    bucketable.method_35170(customdata.method_57461());
                    bucketable.method_6454(true);
                }
                if (player != null) {
                    serverLevel.method_33596(player, class_5712.field_28738, pos);
                }
                return BucketLibUtil.removeEntityData(itemStack, serverLevel, player, entity, damage);
            }
        }
        return itemStack.method_7972();
    }

    @Override
    @Nonnull
    public class_1269 method_7847(@Nonnull class_1799 itemStack, @Nonnull class_1657 player, @Nonnull class_1309 entity, @Nonnull class_1268 interactionHand) {
        if (entity instanceof class_5761 && !BucketLibUtil.containsEntityType(itemStack) && canHoldEntity(entity.method_5864())) {
            class_1269 result = this.pickupEntityWithBucket(player, interactionHand, (class_1309 & class_5761) entity);
            if (result.method_23665()) {
                return result;
            }
        }
        if (this.canMilkEntities() && BucketLibUtil.isEmpty(itemStack)) {
            return WorldInteractionUtil.tryMilkLivingEntity(itemStack, entity, player, interactionHand);
        }
        //feeding axolotl is done by mixins
        return super.method_7847(itemStack, player, entity, interactionHand);
    }

    private <T extends class_1309 & class_5761> class_1269 pickupEntityWithBucket(class_1657 player, class_1268 interactionHand, T entity) {
        class_1799 itemStack = player.method_5998(interactionHand).method_7972(); //copy to avoid changing the real item stack
        class_3611 containedFluid = Services.FLUID.getContainedFluid(itemStack);
        class_3611 entityBucketFluid = Services.BUCKET.getFluidOfBucketItem((class_1755) entity.method_6452().method_7909());
        if (itemStack.method_7909() instanceof UniversalBucketItem
                && entity.method_5805()
                && entityBucketFluid == containedFluid) {
            entity.method_5783(entity.method_35171(), 1.0F, 1.0F);
            class_1799 filledItemStack = BucketLibUtil.addEntityType(itemStack, entity.method_5864());
            entity.method_6455(filledItemStack);
            class_1937 level = entity.method_37908();
            class_1799 handItemStack = class_5328.method_30270(itemStack, player, filledItemStack, false);
            player.method_6122(interactionHand, handItemStack);
            if (!level.field_9236) {
                class_174.field_1208.method_8932((class_3222)player, new class_1799(entity.method_6452().method_7909()));
            }
            entity.method_31472();
            return class_1269.method_29236(level.field_9236);
        }
        return class_1269.field_5811;
    }

    @Override
    @Nonnull
    public class_1799 method_7861(@Nonnull class_1799 itemStack, @Nonnull class_1937 level, @Nonnull class_1309 player) {
        if (player instanceof class_3222 serverPlayer) {
            class_174.field_1198.method_8821(serverPlayer, new class_1799(class_1802.field_8103));
            serverPlayer.method_7259(class_3468.field_15372.method_14956(class_1802.field_8103));
        }
        if (!level.field_9236) {
            Services.FLUID.curePotionEffects(player, new class_1799(class_1802.field_8103));
            if (BucketLibUtil.notCreative(player)) {
                return BucketLibUtil.removeMilk(itemStack, (class_3218) level, (player instanceof class_1657) ? (class_1657) player : null);
            }
        }
        return itemStack;
    }

    @Override
    public int method_7881(@Nonnull class_1799 itemStack, @Nonnull class_1309 livingEntity) {
        if (BucketLibUtil.containsMilk(itemStack)) {
            return 32;
        }
        return super.method_7881(itemStack, livingEntity);
    }

    @Override
    @Nonnull
    public class_1839 method_7853(@Nonnull class_1799 itemStack) {
        if (BucketLibUtil.containsMilk(itemStack)) {
            return class_1839.field_8946;
        }
        return super.method_7853(itemStack);
    }

    //@Override //overrides the (neo)forge implementation
    public boolean hasCraftingRemainingItem(class_1799 stack) {
        //for using a filled bucket as fuel or in crafting recipes, an empty bucket should remain
        return !BucketLibUtil.isEmpty(stack) && !this.isCracked(stack);
    }

    //@Override //overrides the (neo)forge implementation
    public class_1799 getCraftingRemainingItem(class_1799 itemStack) {
        if (!hasCraftingRemainingItem(itemStack)) {
            return class_1799.field_8037;
        }
        if (BucketLibUtil.isAffectedByInfinityEnchantment(itemStack)) {
            return itemStack.method_7972();
        }
        //remove everything from bucket
        class_1799 result = itemStack.method_7972();
        boolean damaged = BucketLibUtil.containsFluid(result); //damaging is done by fluid handler
        if (BucketLibUtil.containsBlock(result)) {
            result = BucketLibUtil.removeBlock(result, null, null, !damaged); //TODO get ServerLevel!
            damaged = true;
        }
        if (BucketLibUtil.containsEntityType(result)) {
            result = BucketLibUtil.removeEntityData(result, null, null, !damaged); //TODO get ServerLevel!
        }
        if (BucketLibUtil.containsFluid(result) || BucketLibUtil.containsMilk(result)) {
            result = BucketLibUtil.removeFluid(result, null, null); //TODO get ServerLevel!
        }
        return result;
    }

    //@Override //overrides the fabric implementation
    public class_1799 getRecipeRemainder(class_1799 itemStack) {
        return getCraftingRemainingItem(itemStack);
    }

    private boolean getBooleanProperty(Supplier<Boolean> config, boolean defaultValue) {
        if (config != null) {
            return config.get();
        }
        return defaultValue;
    }

    private Integer getIntProperty(Supplier<Integer> config, Integer defaultValue) {
        if (config != null) {
            return config.get();
        }
        return defaultValue;
    }

    @SuppressWarnings("unchecked")
    private <T> boolean isElementListedInProperty(T element, class_6862<T> tag, List<T> defaultList) {
        if (tag != null) {
            if (element instanceof class_2248 block) {
                return block.method_9564().method_26164((class_6862<class_2248>) tag);
            } else if (element instanceof class_3611 fluid) {
                return fluid.method_15785().method_15767((class_6862<class_3611>) tag);
            } else if (element instanceof class_1299<?> entityType) {
                return entityType.method_20210((class_6862<class_1299<?>>) tag);
            }
        }
        return defaultList != null && defaultList.contains(element);
    }

    public class_5321<class_1761> getCreativeTab() {
        if (this.properties.tab == null) {
            this.properties.tab = Services.PLATFORM.getToolsAndUtilitiesTab();
        }
        return this.properties.tab;
    }

    public int getDurability() {
        return getIntProperty(this.properties.durabilityConfig, this.properties.durability);
    }

    public boolean isDyeable() {
        return this.properties.dyeable;
    }

    public int getDefaultColor() {
        return this.properties.defaultColor;
    }

    public Integer getMaxTemperature() {
        return getIntProperty(this.properties.maxTemperatureConfig, this.properties.maxTemperature);
    }

    public Integer getUpperBreakTemperature() {
        return getIntProperty(this.properties.upperBreakTemperatureConfig, this.properties.upperCrackingTemperature);
    }

    public Integer getLowerBreakTemperature() {
        return getIntProperty(this.properties.lowerCrackingTemperatureConfig, this.properties.lowerCrackingTemperature);
    }

    public Integer getMinTemperature() {
        return getIntProperty(this.properties.minTemperatureConfig, this.properties.minTemperature);
    }

    private boolean isCrackingFluid(class_3611 fluid) {
        return isElementListedInProperty(fluid, this.properties.crackingFluidsTag, this.properties.crackingFluids);
    }

    public Integer getBurningTemperature() {
        return getIntProperty(this.properties.burningTemperatureConfig, this.properties.burningTemperature);
    }

    public boolean isBurningFluid(class_3611 fluid) {
        return isElementListedInProperty(fluid, this.properties.burningFluidsTag, this.properties.burningFluids);
    }

    public boolean isBurningBlock(class_2248 block) {
        return isElementListedInProperty(block, this.properties.burningBlocksTag, this.properties.burningBlocks);
    }

    public Integer getFreezingTemperature() {
        return getIntProperty(this.properties.freezingTemperatureConfig, this.properties.freezingTemperature);
    }

    public boolean isFreezingFluid(class_3611 fluid) {
        return isElementListedInProperty(fluid, this.properties.freezingFluidsTag, this.properties.freezingFluids);
    }

    public boolean isFreezingBlock(class_2248 block) {
        return isElementListedInProperty(block, this.properties.freezingBlocksTag, this.properties.freezingBlocks);
    }

    private boolean isDeniedFluid(class_3611 fluid) {
        return isElementListedInProperty(fluid, this.properties.deniedFluidsTag, this.properties.deniedFluids);
    }

    private boolean isAllowedFluid(class_3611 fluid) {
        return isElementListedInProperty(fluid, this.properties.allowedFluidsTag, this.properties.allowedFluids);
    }

    public boolean canMilkEntities() {
        return getBooleanProperty(this.properties.milkingConfig, this.properties.milking);
    }

    private boolean canObtainEntities() {
        return getBooleanProperty(this.properties.entityObtainingConfig, this.properties.entityObtaining);
    }

    private boolean isDeniedEntity(class_1299<?> entityType) {
        return isElementListedInProperty(entityType, this.properties.deniedEntitiesTag, this.properties.deniedEntities);
    }

    private boolean isAllowedEntity(class_1299<?> entityType) {
        return isElementListedInProperty(entityType, this.properties.allowedEntitiesTag, this.properties.allowedEntities);
    }

    private boolean canObtainBlocks() {
        return getBooleanProperty(this.properties.blockObtainingConfig, this.properties.blockObtaining);
    }

    private boolean isDeniedBlock(class_2248 block) {
        return isElementListedInProperty(block, this.properties.deniedBlocksTag, this.properties.deniedBlocks);
    }

    private boolean isAllowedBlock(class_2248 block) {
        return isElementListedInProperty(block, this.properties.allowedBlocksTag, this.properties.allowedBlocks);
    }

    public static class Properties {

        class_5321<class_1761> tab = null;
        int maxStackSize = 16;

        int durability = 0;
        Supplier<Integer> durabilityConfig = null;

        boolean dyeable = false;
        int defaultColor = -1;

        Integer maxTemperature = null;
        Supplier<Integer> maxTemperatureConfig = null;
        Integer upperCrackingTemperature = null;
        Supplier<Integer> upperBreakTemperatureConfig = null;
        Integer lowerCrackingTemperature = null;
        Supplier<Integer> lowerCrackingTemperatureConfig = null;
        Integer minTemperature = null;
        Supplier<Integer> minTemperatureConfig = null;

        List<class_3611> crackingFluids = null;
        class_6862<class_3611> crackingFluidsTag = null;
        List<class_3611> deniedFluids = null;
        class_6862<class_3611> deniedFluidsTag = null;
        List<class_3611> allowedFluids = null;
        class_6862<class_3611> allowedFluidsTag = null;

        Integer burningTemperature = null;
        Supplier<Integer> burningTemperatureConfig = null;
        List<class_3611> burningFluids = null;
        class_6862<class_3611> burningFluidsTag = null;
        List<class_2248> burningBlocks = null;
        class_6862<class_2248> burningBlocksTag = null;

        Integer freezingTemperature = null;
        Supplier<Integer> freezingTemperatureConfig = null;
        List<class_3611> freezingFluids = null;
        class_6862<class_3611> freezingFluidsTag = null;
        List<class_2248> freezingBlocks = null;
        class_6862<class_2248> freezingBlocksTag = null;

        boolean milking = true;
        Supplier<Boolean> milkingConfig = null;

        boolean entityObtaining = true;
        Supplier<Boolean> entityObtainingConfig = null;
        List<class_1299<?>> deniedEntities = null;
        class_6862<class_1299<?>> deniedEntitiesTag = null;
        List<class_1299<?>> allowedEntities = null;
        class_6862<class_1299<?>> allowedEntitiesTag = null;

        boolean blockObtaining = true;
        Supplier<Boolean> blockObtainingConfig = null;
        List<class_2248> deniedBlocks = null;
        class_6862<class_2248> deniedBlocksTag = null;
        List<class_2248> allowedBlocks = null;
        class_6862<class_2248> allowedBlocksTag = null;

        public Properties tab(class_5321<class_1761> tab) {
            this.tab = tab;
            return this;
        }

        public Properties stacksTo(int maxStackSize) {
            if (maxStackSize < 1) {
                throw new RuntimeException("Unable to have stack size lower than 1.");
            }
            this.maxStackSize = maxStackSize;
            return this;
        }

        /**
         * Sets the default durability as a constant value.
         * Don't forget to add your bucket to the item tag "minecraft:enchantable/durability" to enable the Unbreaking enchanting.
         *
         * @param durability default durability
         * @return Properties object
         */
        public Properties durability(int durability) {
            if (durability < 0) {
                throw new RuntimeException("Unable to have a durability lower than 0.");
            }
            this.durability = durability;
            return this;
        }

        /**
         * Sets the default durability through a config option.
         * Don't forget to add your bucket to the item tag "minecraft:enchantable/durability" to enable the Unbreaking enchanting.
         *
         * @param durabilityConfig supplier of the configuration value
         * @return Properties object
         */
        public Properties durability(Supplier<Integer> durabilityConfig) {
            this.durabilityConfig = durabilityConfig;
            return this;
        }

        /**
         * Sets a default color of the bucket and enables colored rendering.
         * Don't forget to add your bucket to the item tag "minecraft:dyeable" to enable the dye recipe.
         *
         * @param defaultColor color value {@link class_5253.class_5254}
         * @return Properties object
         */
        public Properties dyeable(int defaultColor) {
            this.dyeable = true;
            this.defaultColor = defaultColor;
            return this;
        }

        /**
         * Sets a default color of the bucket and enables colored rendering.
         * Don't forget to add your bucket to the item tag "minecraft:dyeable" to enable the dye recipe.
         *
         * @param red red value (0-255)
         * @param green green value (0-255)
         * @param blue blue value (0-255)
         * @return Properties object
         */
        public Properties dyeable(int red, int green, int blue) {
            this.dyeable = true;
            this.defaultColor = class_5253.class_5254.method_57173(red, green, blue);
            return this;
        }

        public Properties maxTemperature(int maxTemperature) {
            this.maxTemperature = maxTemperature;
            return this;
        }

        public Properties maxTemperature(Supplier<Integer> maxTemperatureConfig) {
            this.maxTemperatureConfig = maxTemperatureConfig;
            return this;
        }

        public Properties upperCrackingTemperature(int upperCrackingTemperature) {
            this.upperCrackingTemperature = upperCrackingTemperature;
            return this;
        }

        public Properties upperCrackingTemperature(Supplier<Integer> upperCrackingTemperatureConfig) {
            this.upperBreakTemperatureConfig = upperCrackingTemperatureConfig;
            return this;
        }

        public Properties lowerCrackingTemperature(int lowerBreakTemperature) {
            this.lowerCrackingTemperature = lowerBreakTemperature;
            return this;
        }

        public Properties lowerCrackingTemperature(Supplier<Integer> lowerCrackingTemperatureConfig) {
            this.lowerCrackingTemperatureConfig = lowerCrackingTemperatureConfig;
            return this;
        }

        public Properties minTemperature(int minTemperature) {
            this.minTemperature = minTemperature;
            return this;
        }

        public Properties minTemperature(Supplier<Integer> minTemperatureConfig) {
            this.minTemperatureConfig = minTemperatureConfig;
            return this;
        }

        public Properties crackingFluids(List<class_3611> crackingFluids) {
            this.crackingFluids = crackingFluids;
            return this;
        }

        public Properties crackingFluids(class_6862<class_3611> crackingFluidsTag) {
            this.crackingFluidsTag = crackingFluidsTag;
            return this;
        }

        public Properties burningTemperature(int burningTemperature) {
            this.burningTemperature = burningTemperature;
            return this;
        }

        public Properties burningTemperature(Supplier<Integer> burningTemperatureConfig) {
            this.burningTemperatureConfig = burningTemperatureConfig;
            return this;
        }

        public Properties burningFluids(List<class_3611> burningFluids) {
            this.burningFluids = burningFluids;
            return this;
        }

        public Properties burningFluids(class_6862<class_3611> burningFluidsTag) {
            this.burningFluidsTag = burningFluidsTag;
            return this;
        }

        public Properties burningBlocks(List<class_2248> burningBlocks) {
            this.burningBlocks = burningBlocks;
            return this;
        }

        public Properties burningBlocks(class_6862<class_2248> burningBlocksTag) {
            this.burningBlocksTag = burningBlocksTag;
            return this;
        }

        public Properties freezingTemperature(int freezingTemperature) {
            this.freezingTemperature = freezingTemperature;
            return this;
        }

        public Properties freezingTemperature(Supplier<Integer> freezingTemperatureConfig) {
            this.freezingTemperatureConfig = freezingTemperatureConfig;
            return this;
        }

        public Properties freezingFluids(List<class_3611> freezingFluids) {
            this.freezingFluids = freezingFluids;
            return this;
        }

        public Properties freezingFluids(class_6862<class_3611> freezingFluidsTag) {
            this.freezingFluidsTag = freezingFluidsTag;
            return this;
        }

        public Properties freezingBlocks(List<class_2248> freezingBlocks) {
            this.freezingBlocks = freezingBlocks;
            return this;
        }

        public Properties freezingBlocks(class_6862<class_2248> freezingBlocksTag) {
            this.freezingBlocksTag = freezingBlocksTag;
            return this;
        }

        public Properties deniedFluids(List<class_3611> deniedFluids) {
            this.deniedFluids = deniedFluids;
            return this;
        }

        public Properties deniedFluids(class_6862<class_3611> blockedFluidsTag) {
            this.deniedFluidsTag = blockedFluidsTag;
            return this;
        }

        public Properties allowedFluids(List<class_3611> allowedFluids) {
            this.allowedFluids = allowedFluids;
            return this;
        }

        public Properties allowedFluids(class_6862<class_3611> allowedFluidsTag) {
            this.allowedFluidsTag = allowedFluidsTag;
            return this;
        }

        public Properties disableMilking() {
            this.milking = false;
            return this;
        }

        public Properties milking(Supplier<Boolean> milkingConfig) {
            this.milkingConfig = milkingConfig;
            return this;
        }

        public Properties disableEntityObtaining() {
            this.entityObtaining = false;
            return this;
        }

        public Properties entityObtaining(Supplier<Boolean> entityObtainingConfig) {
            this.entityObtainingConfig = entityObtainingConfig;
            return this;
        }

        public Properties deniedEntities(List<class_1299<?>> deniedEntities) {
            this.deniedEntities = deniedEntities;
            return this;
        }

        public Properties deniedEntities(class_6862<class_1299<?>> deniedEntitiesTag) {
            this.deniedEntitiesTag = deniedEntitiesTag;
            return this;
        }

        public Properties allowedEntities(List<class_1299<?>> allowedEntities) {
            this.allowedEntities = allowedEntities;
            return this;
        }

        public Properties allowedEntities(class_6862<class_1299<?>> allowedEntitiesTag) {
            this.allowedEntitiesTag = allowedEntitiesTag;
            return this;
        }

        public Properties disableBlockObtaining() {
            this.blockObtaining = false;
            return this;
        }

        public Properties blockObtaining(Supplier<Boolean> blockObtainingConfig) {
            this.blockObtainingConfig = blockObtainingConfig;
            return this;
        }

        public Properties deniedBlocks(List<class_2248> deniedBlocks) {
            this.deniedBlocks = deniedBlocks;
            return this;
        }

        public Properties deniedBlocks(class_6862<class_2248> deniedBlocksTag) {
            this.deniedBlocksTag = deniedBlocksTag;
            return this;
        }

        public Properties allowedBlocks(List<class_2248> allowedBlocks) {
            this.allowedBlocks = allowedBlocks;
            return this;
        }

        public Properties allowedBlocks(class_6862<class_2248> allowedBlocksTag) {
            this.allowedBlocksTag = allowedBlocksTag;
            return this;
        }

    }

}
