package de.cech12.bucketlib.client;

import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.client.model.UniversalBucketUnbakedModel;
import de.cech12.bucketlib.mixin.BlockModelAccessor;
import de.cech12.bucketlib.platform.Services;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5253;
import net.minecraft.class_793;
import net.minecraft.class_9282;
import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("unused")
public class BucketLibClientMod implements ClientModInitializer, ModelLoadingPlugin {

    public static final class_2960 UNIVERSAL_BUCKET_MODEL = BucketLib.id("item/universal_bucket");

    private static final Map<class_2960, UniversalBucketUnbakedModel> MODELS = new HashMap<>();

    @Override
    public void onInitializeClient() {
        ModelLoadingPlugin.register(this);
        BucketLibMod.getRegisteredBuckets().forEach(item -> {
            //register item colors
            ColorProviderRegistry.ITEM.register((stack, layer) -> {
                if (layer == 0 && item.isDyeable()) {
                    return class_9282.method_57470(stack, item.getDefaultColor());
                }
                if (layer == 1) {
                    class_3611 fluid = Services.FLUID.getContainedFluid(stack);
                    FluidRenderHandler fluidRenderHandler;
                    if (fluid != class_3612.field_15906 && (fluidRenderHandler = FluidRenderHandlerRegistry.INSTANCE.get(fluid)) != null) {
                        return class_5253.class_5254.method_58144(255, fluidRenderHandler.getFluidColor(null, null, fluid.method_15785()));
                    }
                }
                return -1;
            }, item);
        });

    }

    @Override
    public void onInitializeModelLoader(ModelLoadingPlugin.Context pluginContext) {
        pluginContext.modifyModelOnLoad().register((original, context) -> {
            class_2960 location = context.resourceId();
            if (original instanceof class_793 blockModel) {
                while (location != null) {
                    if (location.equals(UNIVERSAL_BUCKET_MODEL)) {
                        var model = new UniversalBucketUnbakedModel((class_793) original);
                        if (model.getParentLocation() != null) {
                            MODELS.put(((BlockModelAccessor)model).bucketlib_getParentLocation(), model);
                        }
                        return model;
                    }
                    location = blockModel != null ? ((BlockModelAccessor) blockModel).bucketlib_getParentLocation() : null;
                    blockModel = blockModel != null ?  ((BlockModelAccessor) blockModel).bucketlib_getParent() : null;
                }
            }
            return original;
        });
    }

    public static class_1100 getModel(class_2960 location) {
        return MODELS.get(location);
    }
}
