package de.cech12.bucketlib.client.model;

import de.cech12.bucketlib.mixin.ItemModelGeneratorAccessor;
import org.joml.Vector3f;

import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1093;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_3665;
import net.minecraft.class_5819;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_793;
import net.minecraft.class_796;
import net.minecraft.class_801;
import net.minecraft.class_806;

public class GeometryUtils {

    private static final class_796 FACE_BAKERY = new class_796();
    private static final ItemModelGeneratorAccessor ITEM_MODEL_GENERATOR = (ItemModelGeneratorAccessor) new class_801();

    private static final float MASK_OFFSET = 0.002F;

    private GeometryUtils() {}

    public static List<class_785> createUnbakedItemElements(int tintIndex, String name, class_7764 spriteContents) {
        return ITEM_MODEL_GENERATOR.bucketlib_processFrames(tintIndex, name, spriteContents);
    }

    public static List<class_785> createUnbakedItemMaskElements(int tintIndex, String name, class_7764 spriteContents) {
        List<class_785> elements = createUnbakedItemElements(tintIndex, name, spriteContents);
        elements.remove(0);
        int width = spriteContents.method_45807();
        int height = spriteContents.method_45815();
        BitSet bits = new BitSet(width * height);
        spriteContents.method_45817().forEach((frame) -> {
            for(int x = 0; x < width; ++x) {
                for(int y = 0; y < height; ++y) {
                    if (!spriteContents.method_45810(frame, x, y)) {
                        bits.set(x + y * width);
                    }
                }
            }
        });

        for(int y = 0; y < height; ++y) {
            int xStart = -1;

            for(int x = 0; x < width; ++x) {
                boolean opaque = bits.get(x + y * width);
                if (opaque == (xStart == -1)) {
                    if (xStart == -1) {
                        xStart = x;
                    } else {
                        int yEnd;
                        int i;
                        label63:
                        for(yEnd = y + 1; yEnd < height; ++yEnd) {
                            for(i = xStart; i <= x; ++i) {
                                if (!bits.get(i + yEnd * width)) {
                                    break label63;
                                }
                            }
                        }

                        for(i = xStart; i < x; ++i) {
                            for(int j = y; j < yEnd; ++j) {
                                bits.clear(i + j * width);
                            }
                        }

                        elements.add(new class_785(new Vector3f((float)(16 * xStart) / (float)width, 16.0F - (float)(16 * yEnd) / (float)height, 7.5F - MASK_OFFSET), new Vector3f((float)(16 * x) / (float)width, 16.0F - (float)(16 * y) / (float)height, 8.5F + MASK_OFFSET), class_156.method_654(new HashMap<>(), (map) -> {
                            for(class_2350 direction : class_2350.values()) {
                                map.put(direction, new class_783(null, tintIndex, name, new class_787(null, 0)));
                            }
                        }), null, true));

                        xStart = -1;
                    }
                }
            }
        }

        return elements;
    }

    public static List<class_777> bakeElements(class_793 blockModel, class_806 itemOverrides, List<class_785> elements, class_1058 sprite, class_3665 modelState) {
        if (elements.isEmpty()) {
            return List.of();
        } else {
            class_1093.class_1094 simplebakedmodel$builder = (new class_1093.class_1094(blockModel, itemOverrides, false)).method_4747(sprite);
            bakeElements(simplebakedmodel$builder, elements, sprite, modelState);
            return simplebakedmodel$builder.method_4746().method_4707(null, null, class_5819.method_43047());
        }
    }

    private static void bakeElements(class_1093.class_1094 builder, List<class_785> elements, class_1058 sprite, class_3665 modelState) {
        for (class_785 element : elements) {
            element.field_4230.forEach((side, face) -> {
                class_777 quad = bakeElementFace(element, face, sprite, side, modelState);
                if (face.comp_2867() == null) {
                    builder.method_4748(quad);
                } else {
                    builder.method_4745(class_2350.method_23225(modelState.method_3509().method_22936(), face.comp_2867()), quad);
                }
            });
        }
    }

    private static class_777 bakeElementFace(class_785 element, class_783 face, class_1058 sprite, class_2350 direction, class_3665 state) {
        return FACE_BAKERY.method_3468(element.field_4228, element.field_4231, face, sprite, direction, state, element.field_4232, element.field_4229);
    }

}
