package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import net.minecraft.class_1799;
import net.minecraft.class_2609;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin({class_2609.class})
public abstract class AbstractFurnaceBlockEntityMixin {

    @Inject(method = "getBurnDuration", at = @At("RETURN"), cancellable = true)
    private void getBurnDurationProxy(class_1799 itemStack, CallbackInfoReturnable<Integer> cir) {
        if (cir.getReturnValue() <= 0 && itemStack.method_7909() instanceof UniversalBucketItem universalBucketItem)  {
            cir.setReturnValue(universalBucketItem.getBucketBurnTime(itemStack, null));
        }
    }

    @Inject(method = "isFuel", at = @At("RETURN"), cancellable = true)
    private static void isFuelProxy(class_1799 itemStack, CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValue() && itemStack.method_7909() instanceof UniversalBucketItem universalBucketItem)  {
            cir.setReturnValue(universalBucketItem.getBucketBurnTime(itemStack, null) > 0);
        }
    }

}
