package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/**
 * Mixin for the Item class to enable the possibility to configure the item's durability.
 */
@Mixin(class_1799.class)
public abstract class ItemStackMixin implements class_9322 {

    @Shadow public abstract class_1792 getItem();

    @Inject(at = @At("HEAD"), method = "getMaxDamage", cancellable = true)
    public void getMaxDamageProxy(CallbackInfoReturnable<Integer> cir) {
        if (this.getItem() instanceof UniversalBucketItem bucketItem) {
            cir.setReturnValue(bucketItem.getDurability());
        }
    }

    @Inject(at = @At("HEAD"), method = "isDamageableItem", cancellable = true)
    public void isDamageableItemProxy(CallbackInfoReturnable<Boolean> cir) {
        if (this.getItem() instanceof UniversalBucketItem bucketItem) {
            cir.setReturnValue(bucketItem.getDurability() > 0 && !this.method_57826(class_9334.field_49630));
        }
    }

    @Inject(at = @At("HEAD"), method = "getMaxStackSize", cancellable = true)
    public void getMaxStackSizeProxy(CallbackInfoReturnable<Integer> cir) {
        if (this.getItem() instanceof UniversalBucketItem bucketItem) {
            cir.setReturnValue(bucketItem.getMaxStackSize((class_1799) (Object) this));
        }
    }

}
