package de.cech12.bucketlib.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import de.cech12.bucketlib.mixin.MobBucketItemAccessor;
import de.cech12.bucketlib.platform.Services;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5634;
import net.minecraft.class_5761;

public class RegistryUtil {

    public static Codec<class_3611> FLUID_CODEC = Codec.of(new Encoder<>() {
        @Override
        public <T> DataResult<T> encode(class_3611 input, DynamicOps<T> ops, T prefix) {
            return ops.mergeToPrimitive(prefix, ops.createString(Services.REGISTRY.getFluidLocation(input).toString()));
        }
    }, new Decoder<>() {
        @Override
        public <T> DataResult<Pair<class_3611, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success(Pair.of(Services.REGISTRY.getFluid(class_2960.method_60654(ops.getStringValue(input).getOrThrow())), ops.empty()));
        }
    });

    public static Codec<class_2248> BLOCK_CODEC = Codec.of(new Encoder<>() {
        @Override
        public <T> DataResult<T> encode(class_2248 input, DynamicOps<T> ops, T prefix) {
            return ops.mergeToPrimitive(prefix, ops.createString(Services.REGISTRY.getBlockLocation(input).toString()));
        }
    }, new Decoder<>() {
        @Override
        public <T> DataResult<Pair<class_2248, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success(Pair.of(Services.REGISTRY.getBlock(class_2960.method_60654(ops.getStringValue(input).getOrThrow())), ops.empty()));
        }
    });

    public static Codec<class_1299<?>> ENTITY_TYPE_CODEC = Codec.of(new Encoder<>() {
        @Override
        public <T> DataResult<T> encode(class_1299<?> input, DynamicOps<T> ops, T prefix) {
            return ops.mergeToPrimitive(prefix, ops.createString(Services.REGISTRY.getEntityTypeLocation(input).toString()));
        }
    }, new Decoder<>() {
        @Override
        public <T> DataResult<Pair<class_1299<?>, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success(Pair.of(Services.REGISTRY.getEntityType(class_2960.method_60654(ops.getStringValue(input).getOrThrow())), ops.empty()));
        }
    });

    private static List<BucketBlock> bucketBlocks;
    private static List<BucketEntity> bucketEntities;

    private RegistryUtil() {}

    private static void readRegistry() {
        bucketBlocks = new ArrayList<>();
        bucketEntities = new ArrayList<>();
        class_1937 level = Services.PLATFORM.getCurrentLevel();
        for (class_1792 item : Services.REGISTRY.getAllItems()) {
            if (item instanceof class_5634 bucket) {
                if (bucketBlocks.stream().noneMatch(bucketBlock -> bucketBlock.block == bucket.method_7711())) {
                    bucketBlocks.add(new BucketBlock(bucket.method_7711(), bucket));
                }
            }
            if (item instanceof class_1785 bucket) {
                class_1299<?> entityType = ((MobBucketItemAccessor) bucket).bucketlib_getEntityType();
                if (entityType != null && level != null && entityType.method_5883(level) instanceof class_5761) {
                    if (bucketEntities.stream().noneMatch(bucketEntity -> bucketEntity.entityType == entityType)) {
                        bucketEntities.add(new BucketEntity(entityType, Services.BUCKET.getFluidOfBucketItem(bucket), bucket));
                    }
                }
            }
        }
    }

    public static List<BucketBlock> getBucketBlocks() {
        if (bucketBlocks == null) {
            readRegistry();
        }
        return bucketBlocks;
    }

    public static BucketBlock getBucketBlock(class_2248 block) {
        for (BucketBlock bucketBlock : getBucketBlocks()) {
            if (bucketBlock.block() == block) {
                return bucketBlock;
            }
        }
        return null;
    }

    public static List<BucketEntity> getBucketEntities() {
        if (bucketEntities == null) {
            readRegistry();
        }
        return bucketEntities;
    }

    public static BucketEntity getBucketEntity(class_1299<?> entityType) {
        for (BucketEntity bucketEntity : getBucketEntities()) {
            if (bucketEntity.entityType() == entityType) {
                return bucketEntity;
            }
        }
        return null;
    }

    public record BucketBlock(class_2248 block, class_5634 bucketItem) {}

    public record BucketEntity(class_1299<?> entityType, class_3611 fluid, class_1785 bucketItem) {}

}
