/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api;

import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import java.util.Optional;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BucketLibApi {
    private static final Logger LOGGER = LogManager.getLogger(BucketLibApi.class);

    public static void registerBucket(class_2960 bucketLocation) {
        Optional bucketItem = class_7923.field_41178.method_17966(bucketLocation);
        if (bucketItem.isEmpty()) {
            LOGGER.info("Bucket could not be registered. The given ResourceLocation \"{}\" does not match any registered item in Forge registry.", (Object)bucketLocation);
            return;
        }
        Object t = bucketItem.get();
        if (t instanceof UniversalBucketItem) {
            UniversalBucketItem bucket = (UniversalBucketItem)((Object)t);
            BucketLibApi.registerBucket(bucket);
        } else {
            LOGGER.info("Bucket could not be registered. The item \"{}\" is not a {}.", (Object)bucketLocation, (Object)UniversalBucketItem.class.getName());
        }
    }

    private static void registerBucket(UniversalBucketItem bucket) {
        BucketLibMod.addBucket(bucket);
        BucketLibApi.addItemToTab(bucket);
    }

    private static void addItemToTab(UniversalBucketItem bucket) {
        ItemGroupEvents.modifyEntriesEvent(bucket.getCreativeTab()).register(content -> {
            class_1799 emptyBucket = new class_1799((class_1935)bucket);
            content.method_45420(emptyBucket);
            for (class_3611 fluid : class_7923.field_41173) {
                if (fluid == class_3612.field_15906 || !bucket.canHoldFluid(fluid)) continue;
                content.method_45420(BucketLibUtil.addFluid(emptyBucket, fluid));
            }
            content.method_45420(BucketLibUtil.addMilk(emptyBucket));
            for (RegistryUtil.BucketEntity bucketEntity : RegistryUtil.getBucketEntities()) {
                if (!bucket.canHoldEntity(bucketEntity.entityType()) || !bucket.canHoldFluid(bucketEntity.fluid())) continue;
                class_1799 filledBucket = BucketLibUtil.addFluid(emptyBucket, bucketEntity.fluid());
                filledBucket = BucketLibUtil.addEntityType(filledBucket, bucketEntity.entityType());
                content.method_45420(filledBucket);
            }
            for (RegistryUtil.BucketBlock bucketBlock : RegistryUtil.getBucketBlocks()) {
                if (!bucket.canHoldBlock(bucketBlock.block())) continue;
                content.method_45420(BucketLibUtil.addBlock(emptyBucket, bucketBlock.block()));
            }
        });
    }
}

