/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class EntityIngredient
implements CustomIngredient {
    protected final class_1299<?> entityType;
    protected final class_6862<class_1299<?>> tag;
    private List<class_1799> matchingStacks;

    private EntityIngredient(class_1299<?> entityType, class_6862<class_1299<?>> tag) {
        this.entityType = entityType;
        this.tag = tag;
    }

    public EntityIngredient(Optional<class_2960> blockOptional, Optional<class_6862<class_1299<?>>> tagOptional) {
        this((class_1299<?>)blockOptional.map(arg_0 -> ((class_7922)class_7923.field_41177).method_10223(arg_0)).orElse(null), (class_6862<class_1299<?>>)tagOptional.orElse(null));
    }

    public EntityIngredient(class_1299<?> entityType) {
        this(entityType, null);
    }

    public EntityIngredient(class_6862<class_1299<?>> tag) {
        this(null, tag);
    }

    public boolean test(class_1799 itemStack) {
        List<RegistryUtil.BucketEntity> bucketEntities;
        if (itemStack == null || itemStack.method_7960()) {
            return false;
        }
        if (this.entityType != null) {
            RegistryUtil.BucketEntity bucketEntity = RegistryUtil.getBucketEntity(this.entityType);
            if (bucketEntity == null) {
                return false;
            }
            bucketEntities = List.of(bucketEntity);
        } else {
            bucketEntities = RegistryUtil.getBucketEntities().stream().filter(bucketBlock -> bucketBlock.entityType().method_20210(this.tag)).toList();
        }
        Iterator<RegistryUtil.BucketEntity> iterator = bucketEntities.iterator();
        if (iterator.hasNext()) {
            RegistryUtil.BucketEntity bucketEntity = iterator.next();
            if (itemStack.method_7909() == bucketEntity.bucketItem()) {
                return true;
            }
            return BucketLibUtil.getEntityType(itemStack) == bucketEntity.entityType();
        }
        return false;
    }

    public List<class_1799> getMatchingStacks() {
        if (this.matchingStacks == null) {
            this.matchingStacks = new ArrayList<class_1799>();
            ArrayList entityTypes = new ArrayList();
            Optional entityTag = Optional.empty();
            if (this.tag != null) {
                entityTag = class_7923.field_41177.method_40266(this.tag);
            }
            if (entityTag.isPresent()) {
                ((class_6885.class_6888)entityTag.get()).forEach(fluid -> entityTypes.add((class_1299)fluid.comp_349()));
            } else if (this.entityType != null) {
                entityTypes.add(this.entityType);
            }
            List<RegistryUtil.BucketEntity> bucketEntities = RegistryUtil.getBucketEntities().stream().filter(bucketEntity -> entityTypes.contains(bucketEntity.entityType())).toList();
            for (RegistryUtil.BucketEntity bucketEntity2 : bucketEntities) {
                this.matchingStacks.add(new class_1799((class_1935)bucketEntity2.bucketItem()));
            }
            for (RegistryUtil.BucketEntity bucketEntity2 : bucketEntities) {
                BucketLibMod.getRegisteredBuckets().forEach(bucket -> {
                    if (bucket.canHoldFluid(bucketEntity2.fluid()) && bucket.canHoldEntity(bucketEntity2.entityType())) {
                        class_1799 filledBucket = new class_1799((class_1935)bucket);
                        if (bucketEntity2.fluid() != class_3612.field_15906) {
                            filledBucket = BucketLibUtil.addFluid(filledBucket, bucketEntity2.fluid());
                        }
                        filledBucket = BucketLibUtil.addEntityType(filledBucket, bucketEntity2.entityType());
                        this.matchingStacks.add(filledBucket);
                    }
                });
            }
        }
        return this.matchingStacks;
    }

    public boolean requiresTesting() {
        return true;
    }

    public CustomIngredientSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    implements CustomIngredientSerializer<EntityIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 NAME = BucketLib.id("entity");
        public static final MapCodec<EntityIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2960.field_25139.optionalFieldOf("entity").forGetter(i -> Optional.of(class_7923.field_41177.method_10221(i.entityType))), (App)class_6862.method_40090((class_5321)class_7923.field_41177.method_30517()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))).apply((Applicative)builder, EntityIngredient::new));
        private static final class_9139<class_9129, EntityIngredient> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public class_2960 getIdentifier() {
            return NAME;
        }

        public MapCodec<EntityIngredient> getCodec(boolean allowEmpty) {
            return CODEC;
        }

        public class_9139<class_9129, EntityIngredient> getPacketCodec() {
            return PACKET_CODEC;
        }

        @Nonnull
        private static EntityIngredient read(class_9129 buffer) {
            String entity = buffer.method_19772();
            String tagId = buffer.method_19772();
            if (!tagId.isEmpty()) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60654((String)tagId));
                return new EntityIngredient(tag);
            }
            if (entity.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a entity ingredient with no entity or tag.");
            }
            return new EntityIngredient((class_1299)class_7923.field_41177.method_10223(class_2960.method_60654((String)entity)));
        }

        private static void write(@Nonnull class_9129 buffer, @Nonnull EntityIngredient ingredient) {
            buffer.method_10814(ingredient.entityType != null ? Objects.requireNonNull(class_7923.field_41177.method_10221(ingredient.entityType)).toString() : "");
            buffer.method_10814(ingredient.tag != null ? ingredient.tag.comp_327().toString() : "");
        }
    }
}

