/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.client.model;

import com.google.common.collect.Maps;
import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.client.BucketLibClientMod;
import de.cech12.bucketlib.client.model.GeometryUtils;
import de.cech12.bucketlib.client.model.UniversalBucketBakedModel;
import de.cech12.bucketlib.mixin.BlockModelAccessor;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_806;

public class UniversalBucketUnbakedModel
extends class_793
implements class_1100 {
    private static final Map<class_2960, class_2960> TEXTURE_MAP = Maps.newHashMap();
    private static final class_4730 MISSING_LOWER_CONTENT_MATERIAL = new class_4730(class_1723.field_21668, UniversalBucketUnbakedModel.getContentTexture(BucketLib.id("missing_lower_content")));
    @Nonnull
    private class_3611 fluid = class_3612.field_15906;
    @Nullable
    private class_2960 otherContent = null;
    private boolean isCracked = false;
    private boolean isLower = false;

    public UniversalBucketUnbakedModel(class_793 blockModel) {
        super(((BlockModelAccessor)blockModel).bucketlib_getParentLocation(), blockModel.method_3433(), ((BlockModelAccessor)blockModel).bucketlib_getTextureMap(), Boolean.valueOf(blockModel.method_3444()), blockModel.method_24298(), blockModel.method_3443(), blockModel.method_3434());
    }

    public UniversalBucketUnbakedModel(class_793 blockModel, @Nonnull class_3611 fluid, @Nullable class_2960 otherContent, boolean isCracked, boolean isLower) {
        this(blockModel);
        this.fluid = fluid;
        this.otherContent = otherContent;
        this.isCracked = isCracked;
        this.isLower = isLower;
    }

    public UniversalBucketUnbakedModel withFluid(class_3611 newFluid, boolean isCracked) {
        return new UniversalBucketUnbakedModel(this, newFluid, null, isCracked, false);
    }

    public UniversalBucketUnbakedModel withOtherContent(class_2960 otherContent, boolean isCracked, boolean isLower) {
        return new UniversalBucketUnbakedModel(this, class_3612.field_15906, otherContent, isCracked, isLower);
    }

    private static class_2960 getContentTexture(class_2960 otherContentLocation) {
        class_2960 texture = TEXTURE_MAP.get(otherContentLocation);
        if (texture == null) {
            String textureLocation = String.format("item/bucket_content/%s", otherContentLocation.method_12832());
            texture = otherContentLocation.method_45136(textureLocation);
            TEXTURE_MAP.put(otherContentLocation, texture);
        }
        return texture;
    }

    public class_2960 getParentLocation() {
        return this.field_4247;
    }

    @Nonnull
    public class_793 method_3431() {
        this.method_45785(BucketLibClientMod::getModel);
        if (this.field_4253 == null) {
            return this;
        }
        if (BucketLibClientMod.UNIVERSAL_BUCKET_MODEL.equals((Object)this.getParentLocation())) {
            return this.field_4253;
        }
        return this.field_4253.method_3431();
    }

    @Nullable
    public class_1087 method_3446(@Nonnull class_7775 modelBaker, @Nonnull class_793 blockModel, @Nonnull Function<class_4730, class_1058> spriteGetter, @Nonnull class_3665 modelState, boolean bl) {
        class_1058[] sprites;
        class_1058 otherContentSprite;
        this.method_45785(BucketLibClientMod::getModel);
        class_4730 particleLocation = this.method_24077("particle");
        class_1058 particleSprite = null;
        if (this.isValid(particleLocation, spriteGetter)) {
            particleSprite = spriteGetter.apply(particleLocation);
        }
        class_4730 baseLocation = null;
        if (this.isLower) {
            if (this.isCracked) {
                baseLocation = this.method_24077("crackedLowerBase");
            }
            if (!this.isValid(baseLocation, spriteGetter)) {
                baseLocation = this.method_24077("lowerBase");
            }
        } else {
            if (this.isCracked) {
                baseLocation = this.method_24077("crackedBase");
            }
            if (!this.isValid(baseLocation, spriteGetter)) {
                baseLocation = this.method_24077("base");
            }
        }
        class_4730 otherContentLocation = null;
        class_4730 fluidLocation = null;
        class_4730 fluidMaskLocation = null;
        if (this.otherContent != null) {
            otherContentLocation = new class_4730(class_1723.field_21668, UniversalBucketUnbakedModel.getContentTexture(this.otherContent));
        }
        if (this.fluid != class_3612.field_15906) {
            fluidLocation = new class_4730(class_1723.field_21668, UniversalBucketUnbakedModel.getContentTexture(class_7923.field_41173.method_10221((Object)this.fluid)));
            if (this.isCracked) {
                fluidMaskLocation = this.method_24077("crackedFluidMask");
            }
            if (!this.isValid(fluidMaskLocation, spriteGetter)) {
                fluidMaskLocation = this.method_24077("fluidMask");
            }
        }
        if (this.otherContent == null && this.isValid(fluidLocation, spriteGetter)) {
            otherContentLocation = fluidLocation;
        }
        class_1058 baseSprite = null;
        if (this.isValid(baseLocation, spriteGetter)) {
            baseSprite = spriteGetter.apply(baseLocation);
            if (particleSprite == null) {
                particleSprite = baseSprite;
            }
        }
        if (this.isValid(otherContentLocation, spriteGetter)) {
            otherContentSprite = spriteGetter.apply(otherContentLocation);
            if (particleSprite == null) {
                particleSprite = otherContentSprite;
            }
        } else {
            otherContentSprite = spriteGetter.apply(MISSING_LOWER_CONTENT_MATERIAL);
        }
        class_1058 fluidSprite = null;
        if (this.fluid != class_3612.field_15906 && FluidRenderHandlerRegistry.INSTANCE.get(this.fluid) != null && (sprites = Objects.requireNonNull(FluidRenderHandlerRegistry.INSTANCE.get(this.fluid)).getFluidSprites(null, null, this.fluid.method_15785())).length > 0) {
            fluidSprite = sprites[0];
            if (particleSprite == null) {
                particleSprite = fluidSprite;
            }
        }
        ContainedFluidOverrideHandler itemOverrides = new ContainedFluidOverrideHandler(modelBaker, this);
        if (this.fluid != class_3612.field_15906 && !this.fluid.method_15785().method_15767(BucketLibTags.Fluids.NO_FLIPPING) && FluidVariantAttributes.isLighterThanAir((FluidVariant)FluidVariant.of((class_3611)this.fluid))) {
            modelState = class_1086.field_5358;
        }
        ArrayList<class_777> quads = new ArrayList<class_777>();
        if (baseSprite != null) {
            quads.addAll(GeometryUtils.bakeElements(this, itemOverrides, GeometryUtils.createUnbakedItemElements(0, "base", baseSprite.method_45851()), baseSprite, modelState));
        }
        if (this.isValid(otherContentLocation, spriteGetter)) {
            assert (otherContentSprite != null);
            quads.addAll(GeometryUtils.bakeElements(this, itemOverrides, GeometryUtils.createUnbakedItemElements(-1, "content", otherContentSprite.method_45851()), otherContentSprite, modelState));
        } else if (this.isValid(fluidMaskLocation, spriteGetter) && this.fluid != class_3612.field_15906) {
            class_1058 templateSprite = spriteGetter.apply(fluidMaskLocation);
            quads.addAll(GeometryUtils.bakeElements(this, itemOverrides, GeometryUtils.createUnbakedItemMaskElements(1, "fluid", templateSprite.method_45851()), fluidSprite, modelState));
        }
        return new UniversalBucketBakedModel(quads, this.method_3443(), itemOverrides, particleSprite);
    }

    private boolean isValid(class_4730 material, Function<class_4730, class_1058> spriteGetter) {
        return material != null && !class_1047.method_4539().equals((Object)spriteGetter.apply(material).method_45851().method_45816());
    }

    private static final class ContainedFluidOverrideHandler
    extends class_806 {
        private final Map<String, class_1087> cache = Maps.newHashMap();
        private final class_806 nested = class_806.field_4292;
        private final class_7775 baker;
        private final UniversalBucketUnbakedModel parent;
        private Integer upperBreakTemperature = null;
        private Integer lowerBreakTemperature = null;

        private ContainedFluidOverrideHandler(class_7775 baker, UniversalBucketUnbakedModel parent) {
            this.baker = baker;
            this.parent = parent;
        }

        @Nullable
        public class_1087 method_3495(@Nonnull class_1087 originalModel, @Nonnull class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int number) {
            class_1087 overridden = this.nested.method_3495(originalModel, stack, world, entity, number);
            if (overridden != originalModel) {
                return overridden;
            }
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof UniversalBucketItem) {
                class_1087 bakedModel;
                UniversalBucketItem bucket = (UniversalBucketItem)class_17922;
                boolean containsEntityType = false;
                String content = BucketLibUtil.getEntityTypeString(stack);
                if (content != null) {
                    containsEntityType = true;
                } else {
                    content = BucketLibUtil.getContentString(stack);
                }
                class_3611 fluid = null;
                if (content == null) {
                    fluid = BucketLibUtil.getFluid(stack);
                    class_2960 location = class_7923.field_41173.method_10221((Object)fluid);
                    String string = content = location != class_7923.field_41173.method_10137() ? location.toString() : null;
                }
                if (!Objects.equals(this.upperBreakTemperature, bucket.getUpperBreakTemperature()) || !Objects.equals(this.lowerBreakTemperature, bucket.getLowerBreakTemperature())) {
                    this.upperBreakTemperature = bucket.getUpperBreakTemperature();
                    this.lowerBreakTemperature = bucket.getLowerBreakTemperature();
                    this.cache.clear();
                }
                if ((bakedModel = this.cache.get(content)) == null && content != null) {
                    boolean isCracked = bucket.isCracked(stack);
                    UniversalBucketUnbakedModel unbaked = fluid == null ? this.parent.withOtherContent(class_2960.method_60654((String)content), isCracked, containsEntityType) : this.parent.withFluid(fluid, isCracked);
                    bakedModel = unbaked.method_4753(this.baker, class_4730::method_24148, (class_3665)class_1086.field_5350);
                    this.cache.put(content, bakedModel);
                }
                return bakedModel;
            }
            return originalModel;
        }
    }
}

