/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.jei;

import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.class_1299;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import net.minecraft.class_7924;

@JeiPlugin
public class ModJEIPlugin
implements IModPlugin {
    private static final class_2960 ID = BucketLib.id("jei_plugin");

    @Nonnull
    public class_2960 getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registration) {
        for (class_1792 class_17922 : Services.REGISTRY.getRegisteredBuckets()) {
            registration.registerSubtypeInterpreter(class_17922, (stack, context) -> {
                if (BucketLibUtil.containsMilk(stack)) {
                    return "milk";
                }
                class_1299<?> entityType = BucketLibUtil.getEntityType(stack);
                if (entityType != null) {
                    return entityType.method_5882();
                }
                class_2248 block = BucketLibUtil.getBlock(stack);
                if (block != null) {
                    return block.method_9539();
                }
                class_3611 fluid = BucketLibUtil.getFluid(stack);
                if (fluid != null) {
                    return fluid.toString();
                }
                return "empty";
            });
        }
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        if (Services.CONFIG.isInfinityEnchantmentEnabled()) {
            IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
            class_1889 data = new class_1889((class_6880)((class_7225.class_7226)class_7887.method_46817().method_46759(class_7924.field_41265).get()).method_46747(class_1893.field_9125), 1);
            ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
            for (UniversalBucketItem bucketItem : Services.REGISTRY.getRegisteredBuckets()) {
                for (class_3611 fluid : Services.REGISTRY.getAllFluids()) {
                    if (fluid == class_3612.field_15906 || !bucketItem.canHoldFluid(fluid) || !fluid.method_15785().method_15767(BucketLibTags.Fluids.INFINITY_ENCHANTABLE)) continue;
                    class_1799 bucket = BucketLibUtil.addFluid(new class_1799((class_1935)bucketItem), fluid);
                    class_1799 enchantedBucket = bucket.method_7972();
                    enchantedBucket.method_7978(data.field_9093, data.field_9094);
                    recipes.add(factory.createAnvilRecipe(bucket, Collections.singletonList(class_1772.method_7808((class_1889)data)), Collections.singletonList(enchantedBucket)));
                }
            }
            if (!recipes.isEmpty()) {
                registration.addRecipes(RecipeTypes.ANVIL, recipes);
            }
        }
    }
}

