/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.platform;

import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.item.FluidStorageData;
import de.cech12.bucketlib.item.StackItemContext;
import de.cech12.bucketlib.item.UniversalBucketFluidStorage;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.platform.services.IFluidHelper;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorageUtil;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5894;
import org.jetbrains.annotations.Nullable;

public class FabricFluidHelper
implements IFluidHelper {
    @Override
    public class_2561 getFluidDescription(class_3611 fluid) {
        return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    @Override
    public int getFluidTemperature(class_3611 fluid) {
        return FluidVariantAttributes.getTemperature((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    @Override
    public boolean hasMilkFluid() {
        return false;
    }

    @Override
    public class_3611 getMilkFluid() {
        return class_3612.field_15906;
    }

    @Override
    public class_1799 dispenseFluidContainer(class_2342 source, class_1799 stack) {
        class_3218 level = source.comp_1967();
        class_2350 dispenserFacing = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
        class_2338 pos = source.comp_1968().method_10093(dispenserFacing);
        if (BucketLibUtil.isEmpty(stack)) {
            class_3545<Boolean, class_1799> result = this.tryPickUpFluid(stack, null, (class_1937)level, null, pos, dispenserFacing);
            if (((Boolean)result.method_15442()).booleanValue()) {
                if (stack.method_7947() == 1) {
                    return (class_1799)result.method_15441();
                }
                if (!source.comp_1970().method_11075((class_1799)result.method_15441()).method_7960()) {
                    new class_2347().dispense(source, (class_1799)result.method_15441());
                }
                class_1799 stackCopy = stack.method_7972();
                stackCopy.method_7934(1);
                return stackCopy;
            }
        } else {
            class_3545<Boolean, class_1799> result = this.tryPlaceFluid(stack, null, (class_1937)level, null, pos);
            if (((Boolean)result.method_15442()).booleanValue()) {
                return (class_1799)result.method_15441();
            }
        }
        return stack;
    }

    @Override
    public class_3611 getContainedFluid(class_1799 stack) {
        Iterator iterator;
        StackItemContext context = new StackItemContext(stack);
        Storage storage = (Storage)context.find(FluidStorage.ITEM);
        if (storage != null && (iterator = storage.nonEmptyViews().iterator()).hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return ((FluidVariant)view.getResource()).getFluid();
        }
        return class_3612.field_15906;
    }

    @Override
    public class_1799 addFluid(class_1799 stack, class_3611 fluid) {
        StackItemContext context = new StackItemContext(stack);
        Storage storage = (Storage)context.find(FluidStorage.ITEM);
        if (storage instanceof UniversalBucketFluidStorage) {
            UniversalBucketFluidStorage bucketFluidStorage = (UniversalBucketFluidStorage)storage;
            try (Transaction transaction = Transaction.openOuter();){
                if (bucketFluidStorage.insert(FluidVariant.of((class_3611)fluid), 81000L, (TransactionContext)transaction) == 81000L) {
                    transaction.commit();
                }
            }
            class_1799 resultStack = context.getItemVariant().toStack();
            if (!resultStack.method_7960()) {
                resultStack.method_57379(BucketLibMod.STORAGE, (Object)new FluidStorageData(FluidVariant.of((class_3611)fluid), 81000L));
            }
            return resultStack;
        }
        return stack.method_7972();
    }

    @Override
    public class_1799 removeFluid(class_1799 stack, class_3218 level, @Nullable class_1657 player) {
        StackItemContext context = new StackItemContext(stack);
        Storage storage = (Storage)context.find(FluidStorage.ITEM);
        if (storage instanceof UniversalBucketFluidStorage) {
            UniversalBucketFluidStorage bucketFluidStorage = (UniversalBucketFluidStorage)storage;
            try (Transaction transaction = Transaction.openOuter();){
                for (StorageView view : storage.nonEmptyViews()) {
                    bucketFluidStorage.extract((FluidVariant)view.getResource(), 81000L, (TransactionContext)transaction);
                }
                transaction.commit();
            }
            class_1799 resultStack = context.getItemVariant().toStack();
            if (!resultStack.method_7960()) {
                resultStack.method_57381(BucketLibMod.STORAGE);
            }
            return resultStack;
        }
        return stack.method_7972();
    }

    @Override
    public class_3545<Boolean, class_1799> tryPickUpFluid(class_1799 stack, @Nullable class_1657 player, class_1937 level, class_1268 interactionHand, class_2338 pos, class_2350 direction) {
        Storage storage = (Storage)FluidStorage.SIDED.find(level, pos, (Object)direction.method_10153());
        if (storage != null && player != null && FluidStorageUtil.interactWithFluidStorage((Storage)storage, (class_1657)player, (class_1268)interactionHand)) {
            return new class_3545((Object)true, (Object)player.method_5998(interactionHand).method_7972());
        }
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2263) {
            class_2263 bucketPickup = (class_2263)block;
            if (RegistryUtil.getBucketBlock(block) == null) {
                class_1799 fullVanillaBucket = bucketPickup.method_9700(player, (class_1936)level, pos, state);
                class_1792 class_17922 = fullVanillaBucket.method_7909();
                if (class_17922 instanceof class_1755) {
                    UniversalBucketItem universalBucketItem;
                    class_1755 bucketItem = (class_1755)class_17922;
                    class_3611 fluid = Services.BUCKET.getFluidOfBucketItem(bucketItem);
                    class_1792 class_17923 = stack.method_7909();
                    if (class_17923 instanceof UniversalBucketItem && (universalBucketItem = (UniversalBucketItem)class_17923).canHoldFluid(fluid)) {
                        class_3414 sound = bucketPickup.method_32351().orElse(FluidVariantAttributes.getFillSound((FluidVariant)FluidVariant.of((class_3611)fluid)));
                        level.method_8396(player, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
                        class_1799 usedStack = stack.method_7972();
                        usedStack.method_7939(1);
                        usedStack = BucketLibUtil.addFluid(usedStack, fluid);
                        return new class_3545((Object)true, (Object)usedStack);
                    }
                    if (!level.method_8608() && player != null) {
                        ((class_3222)player).field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43470((String)"This fluid cannot be hold by the used fluid container.")));
                    }
                    level.method_8652(pos, state, 3);
                    return new class_3545((Object)false, (Object)stack);
                }
                if (!fullVanillaBucket.method_7960()) {
                    if (!level.method_8608() && player != null) {
                        ((class_3222)player).field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43470((String)(String.valueOf(fullVanillaBucket.method_7909()) + " is not compatible with BucketLib."))));
                        BucketLib.LOG.warn("{} is not an instance of BucketItem and is incompatible with BucketLib.", (Object)fullVanillaBucket.method_7909());
                    }
                    level.method_8652(pos, state, 3);
                    return new class_3545((Object)false, (Object)stack);
                }
            }
        }
        return new class_3545((Object)false, (Object)stack);
    }

    @Override
    public class_3545<Boolean, class_1799> tryPlaceFluid(class_1799 stack, @Nullable class_1657 player, class_1937 level, class_1268 interactionHand, class_2338 pos) {
        class_2402 liquidBlockContainer;
        class_3218 serverLevel;
        Storage storage = (Storage)FluidStorage.SIDED.find(level, pos, null);
        if (storage != null && player != null && FluidStorageUtil.interactWithFluidStorage((Storage)storage, (class_1657)player, (class_1268)interactionHand)) {
            return new class_3545((Object)true, (Object)player.method_5998(interactionHand).method_7972());
        }
        class_3611 fluid = BucketLibUtil.getFluid(stack);
        class_3218 class_32182 = serverLevel = level instanceof class_3218 ? (class_3218)level : null;
        if (level.method_8597().comp_644() && fluid.method_15791(class_3486.field_15517)) {
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            level.method_8396(player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                level.method_8406((class_2394)class_2398.field_11237, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
            return new class_3545((Object)true, (Object)BucketLibUtil.removeFluid(stack, serverLevel, player));
        }
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2402 && (liquidBlockContainer = (class_2402)block).method_10310(player, (class_1922)level, pos, state, fluid)) {
            liquidBlockContainer.method_10311((class_1936)level, pos, state, fluid.method_15785());
            level.method_8396(player, pos, FluidVariantAttributes.getEmptySound((FluidVariant)FluidVariant.of((class_3611)fluid)), class_3419.field_15245, 1.0f, 1.0f);
            return new class_3545((Object)true, (Object)BucketLibUtil.removeFluid(stack, serverLevel, player));
        }
        if ((state.method_26215() || state.method_26188(fluid) || !state.method_26227().method_15769() && !(block instanceof class_2402)) && (level.method_8652(pos, fluid.method_15785().method_15759(), 11) || state.method_26227().method_15771())) {
            level.method_8396(player, pos, FluidVariantAttributes.getEmptySound((FluidVariant)FluidVariant.of((class_3611)fluid)), class_3419.field_15245, 1.0f, 1.0f);
            return new class_3545((Object)true, (Object)BucketLibUtil.removeFluid(stack, serverLevel, player));
        }
        return new class_3545((Object)false, (Object)stack);
    }

    @Override
    public void curePotionEffects(class_1309 entity, class_1799 curativeItem) {
        entity.method_6012();
    }
}

