/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.util;

import de.cech12.bucketlib.api.BucketLibComponents;
import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.mixin.LivingEntityAccessor;
import de.cech12.bucketlib.platform.Services;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5761;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class BucketLibUtil {
    public static final class_2960 MILK_LOCATION = class_2960.method_60656((String)"milk");

    private BucketLibUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean notCreative(class_1297 entity) {
        if (!(entity instanceof class_1657)) return true;
        class_1657 player = (class_1657)entity;
        if (player.method_31549().field_7477) return false;
        return true;
    }

    public static boolean isEmpty(class_1799 itemStack) {
        return !BucketLibUtil.containsFluid(itemStack) && !BucketLibUtil.containsMilk(itemStack) && !BucketLibUtil.containsEntityType(itemStack) && !BucketLibUtil.containsBlock(itemStack);
    }

    public static class_1799 createEmptyResult(class_1799 initialStack, class_1657 player, class_1799 resultStack, class_1268 hand) {
        return BucketLibUtil.createEmptyResult(initialStack, player, resultStack, hand, false);
    }

    public static class_1799 createEmptyResult(class_1799 initialStack, class_1657 player, class_1799 resultStack, class_1268 hand, boolean addAdditionalBucketOnInstaBuild) {
        if (!BucketLibUtil.notCreative((class_1297)player)) {
            if (addAdditionalBucketOnInstaBuild && !player.method_31548().method_7379(resultStack)) {
                player.method_31548().method_7394(resultStack);
            }
            return initialStack;
        }
        if (resultStack.method_7960()) {
            if (!initialStack.method_7960()) {
                if (!player.method_5701()) {
                    player.method_37908().method_8486(player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15075, player.method_5634(), 0.8f, 0.8f + player.method_37908().method_8409().method_43057() * 0.4f, false);
                }
                ((LivingEntityAccessor)player).bucketlib_spawnItemParticles(initialStack, 5);
            }
            player.method_7259(class_3468.field_15383.method_14956((Object)initialStack.method_7909()));
        }
        return resultStack;
    }

    public static void damageByOne(class_1799 stack, class_3218 level, class_1657 player) {
        if (level == null) {
            BucketLibUtil.damageByOne(stack, player instanceof class_3222 ? (class_3222)player : null);
            return;
        }
        if (!stack.method_7960() && stack.method_7963() && !BucketLibUtil.isAffectedByInfinityEnchantment(stack)) {
            stack.method_7956(1, level, player instanceof class_3222 ? (class_3222)player : null, item -> stack.method_7974(0));
        }
    }

    @Deprecated
    public static void damageByOne(class_1799 stack, @Nullable class_3222 player) {
        if (!stack.method_7960() && stack.method_7963() && !BucketLibUtil.isAffectedByInfinityEnchantment(stack)) {
            int newDamageValue = stack.method_7919() + 1;
            if (player != null) {
                class_174.field_1185.method_8960(player, stack, newDamageValue);
            }
            stack.method_7974(newDamageValue);
            if (newDamageValue >= stack.method_7936()) {
                stack.method_7934(1);
                stack.method_7974(0);
            }
        }
    }

    public static boolean isAffectedByInfinityEnchantment(@Nonnull class_1799 itemStack) {
        if (!Services.CONFIG.isInfinityEnchantmentEnabled()) {
            return false;
        }
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof UniversalBucketItem) {
            UniversalBucketItem bucket = (UniversalBucketItem)class_17922;
            class_3611 fluid = BucketLibUtil.getFluid(itemStack);
            return fluid != class_3612.field_15906 && fluid.method_15785().method_15767(BucketLibTags.Fluids.INFINITY_ENCHANTABLE) && class_1890.method_8225((class_6880)((class_7225.class_7226)class_7887.method_46817().method_46759(class_7924.field_41265).get()).method_46747(class_1893.field_9125), (class_1799)itemStack) > 0 && bucket.canHoldFluid(fluid);
        }
        return false;
    }

    private static boolean containsTagContent(class_1799 itemStack, String tagName) {
        class_9279 customdata = (class_9279)itemStack.method_57825(BucketLibComponents.BUCKET_CONTENT, (Object)class_9279.field_49302);
        return customdata.method_57450(tagName);
    }

    private static String getTagContent(class_1799 itemStack, String tagName) {
        class_9279 customdata = (class_9279)itemStack.method_57825(BucketLibComponents.BUCKET_CONTENT, (Object)class_9279.field_49302);
        if (customdata.method_57450(tagName)) {
            return customdata.method_57461().method_10558(tagName);
        }
        return null;
    }

    private static class_1799 setTagContent(class_1799 itemStack, String tagName, String tagContent) {
        class_1799 result = itemStack.method_7972();
        class_9279 customdata = (class_9279)result.method_57825(BucketLibComponents.BUCKET_CONTENT, (Object)class_9279.field_49302);
        class_2487 nbt = customdata.method_57461();
        nbt.method_10582(tagName, tagContent);
        result.method_57379(BucketLibComponents.BUCKET_CONTENT, (Object)class_9279.method_57456((class_2487)nbt));
        return result;
    }

    private static class_1799 removeTagContentNoCopy(class_1799 itemStack, String tagName) {
        class_9279 customdata = (class_9279)itemStack.method_57825(BucketLibComponents.BUCKET_CONTENT, (Object)class_9279.field_49302);
        class_2487 nbt = customdata.method_57461();
        if (nbt.method_10545(tagName)) {
            nbt.method_10551(tagName);
            if (nbt.method_33133()) {
                itemStack.method_57381(BucketLibComponents.BUCKET_CONTENT);
            } else {
                itemStack.method_57379(BucketLibComponents.BUCKET_CONTENT, (Object)class_9279.method_57456((class_2487)nbt));
            }
        }
        return itemStack;
    }

    private static class_1799 removeTagContent(class_1799 itemStack, String tagName) {
        return BucketLibUtil.removeTagContentNoCopy(itemStack.method_7972(), tagName);
    }

    public static boolean containsContent(class_1799 itemStack) {
        return BucketLibUtil.containsTagContent(itemStack, "BucketContent");
    }

    public static class_2960 getContent(class_1799 itemStack) {
        String content = BucketLibUtil.getContentString(itemStack);
        if (content != null) {
            return class_2960.method_60654((String)content);
        }
        return null;
    }

    public static String getContentString(class_1799 itemStack) {
        return BucketLibUtil.getTagContent(itemStack, "BucketContent");
    }

    public static class_1799 addContent(class_1799 itemStack, class_2960 content) {
        return BucketLibUtil.setTagContent(itemStack, "BucketContent", content.toString());
    }

    public static void removeContentNoCopy(class_1799 itemStack, class_3218 level, @Nullable class_1657 player, boolean damage) {
        class_1799 emptyStack = BucketLibUtil.removeTagContentNoCopy(itemStack, "BucketContent");
        if (damage) {
            BucketLibUtil.damageByOne(emptyStack, level, player);
        }
    }

    private static class_1799 removeContent(class_1799 itemStack, class_3218 level, @Nullable class_1657 player, boolean damage) {
        class_1799 emptyStack = BucketLibUtil.removeTagContent(itemStack, "BucketContent");
        if (damage) {
            BucketLibUtil.damageByOne(emptyStack, level, player);
        }
        return emptyStack;
    }

    public static boolean containsMilk(class_1799 itemStack) {
        class_2960 bucketContent = BucketLibUtil.getContent(itemStack);
        if (bucketContent != null && bucketContent.equals((Object)MILK_LOCATION)) {
            return true;
        }
        if (Services.FLUID.hasMilkFluid()) {
            return BucketLibUtil.getFluid(itemStack) == Services.FLUID.getMilkFluid();
        }
        return false;
    }

    public static class_1799 addMilk(class_1799 itemStack) {
        class_1799 filledStack = itemStack;
        if (Services.FLUID.hasMilkFluid()) {
            filledStack = BucketLibUtil.addFluid(filledStack, Services.FLUID.getMilkFluid());
        }
        return BucketLibUtil.addContent(filledStack, MILK_LOCATION);
    }

    public static class_1799 removeMilk(class_1799 itemStack, class_3218 level, @Nullable class_1657 player) {
        return BucketLibUtil.removeFluid(itemStack, level, player);
    }

    public static boolean containsFluid(class_1799 itemStack) {
        return BucketLibUtil.getFluid(itemStack) != class_3612.field_15906;
    }

    public static class_3611 getFluid(class_1799 itemStack) {
        return Services.FLUID.getContainedFluid(itemStack);
    }

    public static class_1799 addFluid(class_1799 itemStack, class_3611 fluid) {
        return Services.FLUID.addFluid(itemStack, fluid);
    }

    public static class_1799 removeFluid(class_1799 itemStack, class_3218 level, @Nullable class_1657 player) {
        AtomicReference<class_1799> resultItemStack = new AtomicReference<class_1799>(itemStack.method_7972());
        if (BucketLibUtil.containsMilk(itemStack)) {
            resultItemStack.set(BucketLibUtil.removeContent(resultItemStack.get(), level, player, !BucketLibUtil.containsFluid(resultItemStack.get())));
        }
        return Services.FLUID.removeFluid(resultItemStack.get(), level, player);
    }

    public static boolean containsEntityType(class_1799 itemStack) {
        return BucketLibUtil.containsTagContent(itemStack, "EntityType");
    }

    public static class_1299<?> getEntityType(class_1799 itemStack) {
        String content = BucketLibUtil.getEntityTypeString(itemStack);
        if (content != null) {
            return Services.REGISTRY.getEntityType(class_2960.method_60654((String)content));
        }
        return null;
    }

    public static String getEntityTypeString(class_1799 itemStack) {
        return BucketLibUtil.getTagContent(itemStack, "EntityType");
    }

    public static class_1799 addEntityType(class_1799 itemStack, class_1299<?> entityType) {
        return BucketLibUtil.setTagContent(itemStack, "EntityType", Services.REGISTRY.getEntityTypeLocation(entityType).toString());
    }

    public static class_1799 removeEntityData(class_1799 itemStack, class_3218 level, @Nullable class_1657 player, boolean damage) {
        class_1299<?> entityType;
        if (level != null && (entityType = BucketLibUtil.getEntityType(itemStack)) != null) {
            class_1297 entity = entityType.method_5883((class_1937)level);
            class_1799 stack = BucketLibUtil.removeEntityData(itemStack, level, player, entity, damage);
            if (entity != null) {
                entity.method_31472();
            }
            return stack;
        }
        return BucketLibUtil.removeEntityData(itemStack, level, player, null, damage);
    }

    public static class_1799 removeEntityData(class_1799 itemStack, class_3218 level, @Nullable class_1657 player, @Nullable class_1297 entity, boolean damage) {
        class_1799 emptyStack = BucketLibUtil.removeTagContent(itemStack, "EntityType");
        HashSet<class_9331> types = new HashSet<class_9331>();
        types.add(class_9334.field_49610);
        if (entity instanceof class_5761) {
            class_5761 bucketable = (class_5761)entity;
            class_1799 emptyVanillaStack = new class_1799((class_1935)BucketLibUtil.getFluid(itemStack).method_15774());
            class_1799 changedVanillaStack = new class_1799((class_1935)BucketLibUtil.getFluid(itemStack).method_15774());
            bucketable.method_6455(changedVanillaStack);
            changedVanillaStack.method_57353().method_57833().forEach(typedDataComponent -> {
                AtomicBoolean addType = new AtomicBoolean(true);
                emptyVanillaStack.method_57353().method_57833().forEach(typedDataComponentVanilla -> {
                    if (typedDataComponent.comp_2443() == typedDataComponentVanilla.comp_2443()) {
                        addType.set(false);
                        if (changedVanillaStack.method_57824(typedDataComponent.comp_2443()) != null && changedVanillaStack.method_57824(typedDataComponent.comp_2443()) != emptyVanillaStack.method_57824(typedDataComponentVanilla.comp_2443())) {
                            types.add(typedDataComponent.comp_2443());
                        }
                    }
                });
                if (addType.get()) {
                    types.add(typedDataComponent.comp_2443());
                }
            });
        }
        for (class_9331 type : types) {
            emptyStack.method_57381(type);
        }
        if (damage) {
            BucketLibUtil.damageByOne(emptyStack, level, player);
        }
        return emptyStack;
    }

    public static boolean containsBlock(class_1799 itemStack) {
        return BucketLibUtil.containsContent(itemStack) && !BucketLibUtil.containsMilk(itemStack);
    }

    public static class_2248 getBlock(class_1799 itemStack) {
        class_2960 content;
        if (!BucketLibUtil.containsMilk(itemStack) && (content = BucketLibUtil.getContent(itemStack)) != null) {
            return Services.REGISTRY.getBlock(content);
        }
        return null;
    }

    public static class_1799 addBlock(class_1799 itemStack, class_2248 block) {
        class_2960 blockLocation = Services.REGISTRY.getBlockLocation(block);
        if (blockLocation != null) {
            return BucketLibUtil.addContent(itemStack, blockLocation);
        }
        return itemStack.method_7972();
    }

    public static class_1799 removeBlock(class_1799 itemStack, class_3218 level, @Nullable class_1657 player, boolean damage) {
        if (!BucketLibUtil.containsMilk(itemStack)) {
            return BucketLibUtil.removeContent(itemStack, level, player, damage);
        }
        return itemStack.method_7972();
    }
}

