package de.cech12.bucketlib.api;

import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.Optional;

public class BucketLibApi {

    private static final Logger LOGGER = LogManager.getLogger(BucketLibApi.class);

    public static void registerBucket(class_2960 bucketLocation) {
        Optional<class_1792> bucketItem = class_7923.field_41178.method_17966(bucketLocation);
        if (bucketItem.isEmpty()) {
            LOGGER.info("Bucket could not be registered. The given ResourceLocation \"{}\" does not match any registered item in Forge registry.", bucketLocation);
            return;
        }
        if (bucketItem.get() instanceof UniversalBucketItem bucket) {
            registerBucket(bucket);
        } else {
            LOGGER.info("Bucket could not be registered. The item \"{}\" is not a {}.", bucketLocation, UniversalBucketItem.class.getName());
        }
    }

    private static void registerBucket(UniversalBucketItem bucket) {
        BucketLibMod.addBucket(bucket);
        addItemToTab(bucket);
    }

    private static void addItemToTab(UniversalBucketItem bucket) {
        ItemGroupEvents.modifyEntriesEvent(bucket.getCreativeTab()).register(content -> {
            class_1799 emptyBucket = new class_1799(bucket);
            //add empty bucket
            content.method_45420(emptyBucket);
            //add fluid buckets
            for (class_3611 fluid : class_7923.field_41173) {
                if (fluid == class_3612.field_15906) {
                    continue;
                }
                //Fabric has no common milk fluid
                if (bucket.canHoldFluid(fluid)) {
                    content.method_45420(BucketLibUtil.addFluid(emptyBucket, fluid));
                }
            }
            //add milk bucket
            content.method_45420(BucketLibUtil.addMilk(emptyBucket));
            //add entity buckets
            for (RegistryUtil.BucketEntity bucketEntity : RegistryUtil.getBucketEntities()) {
                if (bucket.canHoldEntity(bucketEntity.entityType()) && bucket.canHoldFluid(bucketEntity.fluid())) {
                    class_1799 filledBucket = BucketLibUtil.addFluid(emptyBucket, bucketEntity.fluid());
                    filledBucket = BucketLibUtil.addEntityType(filledBucket, bucketEntity.entityType());
                    content.method_45420(filledBucket);
                }
            }
            //add block buckets
            for (RegistryUtil.BucketBlock bucketBlock : RegistryUtil.getBucketBlocks()) {
                if (bucket.canHoldBlock(bucketBlock.block())) {
                    content.method_45420(BucketLibUtil.addBlock(emptyBucket, bucketBlock.block()));
                }
            }
        });
    }

}
