package de.cech12.bucketlib.item;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5633;

public class UniversalBucketDispenseBehaviour extends class_2347 {

    private static final UniversalBucketDispenseBehaviour INSTANCE = new UniversalBucketDispenseBehaviour();

    public static UniversalBucketDispenseBehaviour getInstance()
    {
        return INSTANCE;
    }

    private UniversalBucketDispenseBehaviour() {}

    private final class_2347 dispenseBehavior = new class_2347();

    @Override
    @Nonnull
    public class_1799 method_10135(@Nonnull class_2342 source, @Nonnull class_1799 stack) {
        if (stack.method_7909() instanceof UniversalBucketItem) {
            if (BucketLibUtil.isEmpty(stack)) {
                return fillBucket(source, stack);
            } else {
                return emptyBucket(source, stack);
            }
        }
        return Services.FLUID.dispenseFluidContainer(source, stack);
    }

    private class_1799 fillBucket(@Nonnull class_2342 source, @Nonnull class_1799 stack) {
        class_3218 level = source.comp_1967();
        class_2338 pickupPosition = source.comp_1968().method_10093(source.comp_1969().method_11654(class_2315.field_10918));
        class_2680 blockState = level.method_8320(pickupPosition);
        RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(blockState.method_26204());
        if (bucketBlock != null) {
            //pickup block
            if (stack.method_7909() instanceof UniversalBucketItem universalBucketItem
                    && universalBucketItem.canHoldBlock(bucketBlock.block())
                    && bucketBlock.block() instanceof class_2263 bucketPickup
            ) {
                class_1799 vanillaStack = bucketPickup.method_9700(null, level, pickupPosition, blockState);
                if (!vanillaStack.method_7960()) {
                    if (stack.method_7947() == 1) {
                        return BucketLibUtil.addBlock(stack, bucketBlock.block());
                    }
                    class_1799 usedStack = stack.method_7972();
                    usedStack.method_7939(1);
                    class_1799 resultStack = BucketLibUtil.addBlock(usedStack, bucketBlock.block());
                    if (stack.method_7947() == 1) {
                        return resultStack;
                    }
                    if (!(source.comp_1970()).method_11075(resultStack).method_7960()) {
                        this.dispenseBehavior.dispense(source, resultStack);
                    }
                    class_1799 stackCopy = stack.method_7972();
                    stackCopy.method_7934(1);
                    return stackCopy;
                }

            }
        }
        return Services.FLUID.dispenseFluidContainer(source, stack);
    }

    private class_1799 emptyBucket(@Nonnull class_2342 source, @Nonnull class_1799 stack) {
        class_3218 level = source.comp_1967();
        class_2338 placePosition = source.comp_1968().method_10093(source.comp_1969().method_11654(class_2315.field_10918));
        if (BucketLibUtil.containsBlock(stack)) {
            //place block
            class_2248 placeBlock = BucketLibUtil.getBlock(stack);
            if (placeBlock != null && placeBlock.method_8389() instanceof class_5633 dispensibleContainerItem) {
                if (dispensibleContainerItem.method_7731(null, level, placePosition, null)) {
                    return BucketLibUtil.removeBlock(stack, level, null, true);
                }
            }
        } else if (BucketLibUtil.containsEntityType(stack)) {
            //place entity
            if (stack.method_7909() instanceof UniversalBucketItem bucketItem) {
                if (BucketLibUtil.containsFluid(stack)) {
                    //fluid can only be placed correctly if the entity is not inside
                    class_1799 stackWithoutEntity = BucketLibUtil.removeEntityType(stack.method_7972(), level, null, false);
                    class_1799 fluidResult = Services.FLUID.dispenseFluidContainer(source, stackWithoutEntity);
                    bucketItem.spawnEntityFromBucket(null, source.comp_1967(), stack, placePosition, false);
                    return fluidResult;
                } else {
                    return bucketItem.spawnEntityFromBucket(null, source.comp_1967(), stack, placePosition, true);
                }
            }
        }
        return Services.FLUID.dispenseFluidContainer(source, stack);
    }

}
