package de.cech12.bucketlib.item.crafting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BucketFillingShapedRecipe extends class_1869 {

    private final class_7710 category;
    private final class_8957 pattern;
    private final BucketFillingType fillingType;
    private final class_3611 fluid;
    private final class_2248 block;
    private final class_1299<?> entityType;

    public BucketFillingShapedRecipe(String group, class_7710 category, class_8957 pattern, BucketFillingType fillingType, Optional<class_3611> fluid, Optional<class_2248> block, Optional<class_1299<?>> entityType) {
        super(group, category, pattern, getAssembledBucket(fillingType, fluid.orElse(null), block.orElse(null), entityType.orElse(null), pattern.method_59997().stream().filter(Optional::isPresent).map(ingredient -> ingredient.get().method_8105().stream().map(itemHolder -> new class_1799(itemHolder.comp_349())).toList()).flatMap(List::stream).toList()));
        this.category = category;
        this.pattern = pattern;
        this.fillingType = fillingType;
        this.fluid = fluid.orElse(null);
        this.block = block.orElse(null);
        this.entityType = entityType.orElse(null);
    }

    private static class_1799 getAffectedBucket(List<class_1799> itemStacks) {
        for (class_1799 stack : itemStacks) {
            if (stack.method_7909() instanceof UniversalBucketItem && BucketLibUtil.isEmpty(stack)) {
                class_1799 bucket = stack.method_7972();
                bucket.method_7939(1);
                return bucket;
            }
        }
        return class_1799.field_8037;
    }

    private static class_1799 getAssembledBucket(BucketFillingType fillingType, class_3611 fluid, class_2248 block, class_1299<?> entityType, List<class_1799> itemStacks) {
        class_1799 bucket = getAffectedBucket(itemStacks);
        if (bucket.method_7909() instanceof UniversalBucketItem universalBucketItem) {
            if (fillingType == BucketFillingType.BLOCK && universalBucketItem.canHoldBlock(block)) {
                return BucketLibUtil.addBlock(bucket, block);
            } else if (fillingType == BucketFillingType.ENTITY && universalBucketItem.canHoldEntity(entityType) && (fluid == null || universalBucketItem.canHoldFluid(fluid))) {
                if (fluid != null) {
                    bucket = BucketLibUtil.addFluid(bucket, fluid);
                }
                return BucketLibUtil.addEntityType(bucket, entityType);
            } else if (fillingType == BucketFillingType.FLUID && universalBucketItem.canHoldFluid(fluid)) {
                return BucketLibUtil.addFluid(bucket, fluid);
            } else if (fillingType == BucketFillingType.MILK && universalBucketItem.canMilkEntities()) {
                return BucketLibUtil.addMilk(bucket);
            }
        }
        return class_1799.field_8037;
    }

    /**
     * Used to check if a recipe matches current crafting inventory
     */
    @Override
    public boolean method_17728(@Nonnull class_9694 input, @Nonnull class_1937 level) {
        class_1799 bucket = getAffectedBucket(input.method_59989());
        if (bucket == class_1799.field_8037) {
            return false;
        }
        UniversalBucketItem universalBucketItem = ((UniversalBucketItem)bucket.method_7909());
        return super.method_17728(input, level)
                && (this.fillingType != BucketFillingType.BLOCK || universalBucketItem.canHoldBlock(this.block))
                && (this.fillingType != BucketFillingType.ENTITY || (universalBucketItem.canHoldEntity(this.entityType) && (this.fluid == null || universalBucketItem.canHoldFluid(this.fluid))))
                && (this.fillingType != BucketFillingType.FLUID || universalBucketItem.canHoldFluid(this.fluid))
                && (this.fillingType != BucketFillingType.MILK || universalBucketItem.canMilkEntities());
    }

    /**
     * Returns an Item that is the result of this recipe
     */
    @Override
    @Nonnull
    public class_1799 method_17727(@Nonnull class_9694 input, @Nonnull class_7225.class_7874 provider) {
        return getAssembledBucket(this.fillingType, this.fluid, this.block, this.entityType, input.method_59989());
    }


    @Override
    @Nonnull
    public class_1865<? extends class_1869> method_8119() {
        return Serializer.INSTANCE;
    }

    public static class Serializer implements class_1865<BucketFillingShapedRecipe> {

        public static final Serializer INSTANCE = new Serializer();

        private static final MapCodec<BucketFillingShapedRecipe> CODEC = RecordCodecBuilder.mapCodec((record) ->
                record.group(
                        Codec.STRING.optionalFieldOf("group", "").forGetter(class_1869::method_8112),
                        class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter((recipe) -> recipe.category),
                        class_8957.field_47321.forGetter((recipe) -> recipe.pattern),
                        BucketFillingType.CODEC.fieldOf("filling_type").forGetter((recipe) -> recipe.fillingType),
                        RegistryUtil.FLUID_CODEC.optionalFieldOf("fluid").forGetter(recipe -> Optional.of(recipe.fluid)),
                        RegistryUtil.BLOCK_CODEC.optionalFieldOf("block").forGetter(recipe -> Optional.of(recipe.block)),
                        RegistryUtil.ENTITY_TYPE_CODEC.optionalFieldOf("entity").forGetter(recipe -> Optional.of(recipe.entityType))
                ).apply(record, BucketFillingShapedRecipe::new));

        private static final class_9139<class_9129, BucketFillingShapedRecipe> STREAM_CODEC = class_9139.method_56437(
                BucketFillingShapedRecipe.Serializer::toNetwork,
                BucketFillingShapedRecipe.Serializer::fromNetwork);

        public Serializer() {
        }

        @Override
        @Nonnull
        public MapCodec<BucketFillingShapedRecipe> method_53736() {
            return CODEC;
        }

        @Override
        @Nonnull
        public class_9139<class_9129, BucketFillingShapedRecipe> method_56104() {
            return STREAM_CODEC;
        }

        @Nonnull
        private static BucketFillingShapedRecipe fromNetwork(class_9129 buf) {
            String group = buf.method_19772();
            class_7710 category = buf.method_10818(class_7710.class);
            class_8957 pattern = class_8957.field_48359.decode(buf);
            BucketFillingType fillingType = buf.method_10818(BucketFillingType.class);
            Optional<class_3611> fluid = Optional.empty();
            Optional<class_2248> block = Optional.empty();
            Optional<class_1299<?>> entityType = Optional.empty();
            if (fillingType == BucketFillingType.BLOCK) {
                block = Optional.of(Services.REGISTRY.getBlock(buf.method_10810()));
            } else if (fillingType == BucketFillingType.ENTITY) {
                entityType = Optional.of(Services.REGISTRY.getEntityType(buf.method_10810()));
                fluid = Optional.of(Services.REGISTRY.getFluid(buf.method_10810()));
                if (fluid.get() == class_3612.field_15906) {
                    fluid = Optional.empty();
                }
            } else if (fillingType == BucketFillingType.FLUID) {
                fluid = Optional.of(Services.REGISTRY.getFluid(buf.method_10810()));
            }
            return new BucketFillingShapedRecipe(group, category, pattern, fillingType, fluid, block, entityType);
        }

        private static void toNetwork(class_9129 buf, BucketFillingShapedRecipe recipe) {
            buf.method_10814(recipe.method_8112());
            buf.method_10817(recipe.category);
            class_8957.field_48359.encode(buf, recipe.pattern);
            buf.method_10817(recipe.fillingType);
            if (recipe.fillingType == BucketFillingType.BLOCK) {
                buf.method_10812(Objects.requireNonNull(Services.REGISTRY.getBlockLocation(recipe.block)));
            } else if (recipe.fillingType == BucketFillingType.ENTITY) {
                buf.method_10812(Objects.requireNonNull(Services.REGISTRY.getEntityTypeLocation(recipe.entityType)));
                buf.method_10812(Objects.requireNonNull(Services.REGISTRY.getFluidLocation((recipe.fluid != null ? recipe.fluid : class_3612.field_15906))));
            } else if (recipe.fillingType == BucketFillingType.FLUID) {
                buf.method_10812(Services.REGISTRY.getFluidLocation(recipe.fluid));
            }
        }
    }

}
