package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import net.minecraft.class_5768;

@Mixin(class_5768.class)
public class AxolotlAiMixin {

    @Unique
    private static final Predicate<class_1799> bucketLib$predicate = stack -> {
        class_1299<?> entityType;
        RegistryUtil.BucketEntity bucketEntity;
        if (stack.method_7909() instanceof UniversalBucketItem
                && (entityType = BucketLibUtil.getEntityType(stack)) != null
                && (bucketEntity = RegistryUtil.getBucketEntity(entityType)) != null) {
            return new class_1799(bucketEntity.bucketItem()).method_31573(class_3489.field_49957);
        }
        return false;
    };

    @Inject(at = @At("RETURN"), method = "getTemptations", cancellable = true)
    private static void getTemptationsProxy(CallbackInfoReturnable<Predicate<class_1799>> cir) {
        cir.setReturnValue(cir.getReturnValue().or(bucketLib$predicate));
    }

}
