package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_5762;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin({class_5762.class})
public abstract class AxolotlMixin extends class_1429 {

	private AxolotlMixin(class_1299<? extends class_1429> entityType, class_1937 level) {
		super(entityType, level);
	}

	@Inject(at = @At("RETURN"), method = "isFood", cancellable = true)
	private void isFoodProxy(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
		if (!cir.getReturnValue() && stack.method_7909() instanceof UniversalBucketItem) {
			class_1299<?> entityType;
			RegistryUtil.BucketEntity bucketEntity;
			if ((entityType = BucketLibUtil.getEntityType(stack)) != null
					&& (bucketEntity = RegistryUtil.getBucketEntity(entityType)) != null) {
				cir.setReturnValue(new class_1799(bucketEntity.bucketItem()).method_31573(class_3489.field_49957));
			}
		}
	}

	@Inject(at = @At("HEAD"), method = "usePlayerItem", cancellable = true)
	private void usePlayerItemProxy(class_1657 player, class_1268 hand, class_1799 stack, CallbackInfo ci) {
		if (this.method_6481(stack) && stack.method_7909() instanceof UniversalBucketItem) {
			class_3218 serverLevel = (player.method_37908() instanceof class_3218) ? (class_3218) player.method_37908() : null;
			player.method_6122(hand, BucketLibUtil.removeEntityType(stack, serverLevel, player, true));
			ci.cancel();
		}
	}

}
