package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import net.minecraft.class_1799;
import net.minecraft.class_1849;
import net.minecraft.class_2371;
import net.minecraft.class_3955;
import net.minecraft.class_9694;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3955.class)
public interface CraftingRecipeMixin {

    @Inject(at = @At("RETURN"), method = "getRemainingItems", cancellable = true)
    default void getRemainingItems(class_9694 craftingInput, CallbackInfoReturnable<class_2371<class_1799>> cir) {
        if ((Object)this instanceof class_1849) {
            class_2371<class_1799> list = cir.getReturnValue();
            boolean changed = false;
            for (int i = 0; i < list.size(); i++) {
                class_1799 stack = list.get(i);
                if (stack.method_7909() instanceof UniversalBucketItem) {
                    list.set(i, class_1799.field_8037); //for bucket coloring we don't want to return the remainder
                    changed = true;
                }
            }
            if (changed) {
                cir.setReturnValue(list);
            }
        }
    }
}
