package de.cech12.bucketlib.platform.services;

import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3611;

/**
 * Common fluid helper service interface.
 */
public interface IFluidHelper {

    class_2561 getFluidDescription(class_3611 fluid);

    int getFluidTemperature(class_3611 fluid);

    boolean hasMilkFluid();

    class_3611 getMilkFluid();

    class_1799 dispenseFluidContainer(class_2342 source, class_1799 stack);

    class_3611 getContainedFluid(class_1799 stack);

    class_1799 addFluid(class_1799 stack, class_3611 fluid);

    class_1799 removeFluid(class_1799 stack, class_3218 level, @Nullable class_1657 player);

    class_3545<Boolean, class_1799> tryPickUpFluid(class_1799 stack, class_1657 player, class_1937 level, class_1268 interactionHand, class_2338 pos, class_2350 direction);

    class_3545<Boolean, class_1799> tryPlaceFluid(class_1799 stack, class_1657 player, class_1937 level, class_1268 interactionHand, class_2338 pos);

    void curePotionEffects(class_1309 entity, class_1799 curativeItem);

}
