package de.cech12.bucketlib.platform.services;

import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_5321;

/**
 * Common platform helper service interface.
 */
public interface IPlatformHelper {

    /**
     * Gets the name of the current platform
     *
     * @return The name of the current platform.
     */
    String getPlatformName();

    /**
     * Checks if a mod with the given id is loaded.
     *
     * @param modId The mod to check if it is loaded.
     * @return True if the mod is loaded, false otherwise.
     */
    boolean isModLoaded(String modId);

    /**
     * Check if the game is currently in a development environment.
     *
     * @return True if in a development environment, false otherwise.
     */
    boolean isDevelopmentEnvironment();

    /**
     * Gets the name of the environment type as a string.
     *
     * @return The name of the environment type.
     */
    default String getEnvironmentName() {
        return isDevelopmentEnvironment() ? "development" : "production";
    }

    /**
     * Gets the current level.
     *
     * @return the current level.
     */
    class_1937 getCurrentLevel();

    /**
     * Gets the TOOLS_AND_UTILITIES creative tab.
     *
     * @return TOOLS_AND_UTILITIES creative tab.
     */
    class_5321<class_1761> getToolsAndUtilitiesTab();

    /**
     * Gets the translation key for milk.
     *
     * @return translation key for milk
     */
    String getMilkTranslationKey();

    /**
     * Gets the burn time of an ItemStack.
     *
     * @return burn time of an ItemStack
     */
    int getBurnTime(class_1799 stack, class_3956<?> recipeType);

}