package de.cech12.bucketlib.util;

import de.cech12.bucketlib.api.BucketLibComponents;
import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.mixin.LivingEntityAccessor;
import de.cech12.bucketlib.platform.Services;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7887;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import java.util.concurrent.atomic.AtomicReference;

public class BucketLibUtil {

    public static final class_2960 MILK_LOCATION = class_2960.method_60656("milk");

    private BucketLibUtil() {}

    public static boolean notCreative(class_1297 entity) {
        return !(entity instanceof class_1657 player) || !player.method_31549().field_7477;
    }

    public static boolean isEmpty(class_1799 itemStack) {
        return !containsFluid(itemStack) && !containsMilk(itemStack) && !containsEntityType(itemStack) && !containsBlock(itemStack);
    }

    public static class_1799 createEmptyResult(class_1799 initialStack, class_1657 player, class_1799 resultStack, class_1268 hand) {
        return createEmptyResult(initialStack, player, resultStack, hand, false);
    }

    public static class_1799 createEmptyResult(class_1799 initialStack, class_1657 player, class_1799 resultStack, class_1268 hand, boolean addAdditionalBucketOnInstaBuild) {
        if (!BucketLibUtil.notCreative(player)) {
            if (addAdditionalBucketOnInstaBuild && !player.method_31548().method_7379(resultStack)) {
                player.method_31548().method_7394(resultStack);
            }
            return initialStack;
        }
        if (resultStack.method_7960()) {
            //player.broadcastBreakEvent(hand); //does not work here to play the sound, because the hand is empty until this event gotten
            if (!initialStack.method_7960()) {
                if (!player.method_5701()) {
                    player.method_37908().method_8486(player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15075, player.method_5634(), 0.8F, 0.8F + player.method_37908().method_8409().method_43057() * 0.4F, false);
                }
                ((LivingEntityAccessor) player).bucketlib_spawnItemParticles(initialStack, 5);
            }
            player.method_7259(class_3468.field_15383.method_14956(initialStack.method_7909()));
        }
        return resultStack;
    }

    /**
     * Adds damage to the bucket if damaging is enabled.
     * @param stack item stack which gets damage
     * @param level ServerLevel
     * @param player Player object or null if no player is involved
     */
    public static void damageByOne(class_1799 stack, class_3218 level, class_1657 player) {
        if (level == null) {
            damageByOne(stack, (player instanceof class_3222) ? (class_3222) player : null); //workaround for contexts without level access (Crafting & fluid handlers)
            return;
        }
        if (!stack.method_7960() && stack.method_7963() && !BucketLibUtil.isAffectedByInfinityEnchantment(stack)) {
            stack.method_7956(1, level, (player instanceof class_3222) ? (class_3222) player : null, (item) -> {
                stack.method_7974(0);
            });
        }
    }

    /**
     * Adds damage to the bucket if damaging is enabled. This method should only be used if there is no ServerLevel in the calling context.
     * Enchantments have no effect here!
     * It is recommended to use {@link #damageByOne(class_1799, class_3218, class_1657)}
     * @param stack item stack which gets damage
     */
    @Deprecated //TODO find a way to get server level access in all calling contexts
    public static void damageByOne(class_1799 stack, @Nullable class_3222 player) {
        if (!stack.method_7960() && stack.method_7963() && !BucketLibUtil.isAffectedByInfinityEnchantment(stack)) {
            int newDamageValue = stack.method_7919() + 1;
            if (player != null) {
                class_174.field_1185.method_8960(player, stack, newDamageValue);
            }
            stack.method_7974(newDamageValue);
            if (newDamageValue >= stack.method_7936()) {
                stack.method_7934(1);
                stack.method_7974(0);
            }
        }
    }

    /**
     * Checks if the given bucket is affected by Infinity enchantment.
     * @param itemStack checked item stack
     * @return boolean
     */
    public static boolean isAffectedByInfinityEnchantment(@Nonnull class_1799 itemStack) {
        if (!Services.CONFIG.isInfinityEnchantmentEnabled()) {
            return false;
        }
        if (itemStack.method_7909() instanceof UniversalBucketItem bucket) {
            class_3611 fluid = getFluid(itemStack);
            return fluid != class_3612.field_15906
                    && fluid.method_15785().method_15767(BucketLibTags.Fluids.INFINITY_ENCHANTABLE)
                    && class_1890.method_8225(class_7887.method_46817().method_46759(class_7924.field_41265).get().method_46747(class_1893.field_9125), itemStack) > 0
                    && bucket.canHoldFluid(fluid);
        }
        return false;
    }

    private static boolean containsTagContent(class_1799 itemStack, String tagName) {
        class_9279 customdata = itemStack.method_57825(BucketLibComponents.BUCKET_CONTENT, class_9279.field_49302);
        return customdata.method_57450(tagName);
    }

    private static String getTagContent(class_1799 itemStack, String tagName) {
        class_9279 customdata = itemStack.method_57825(BucketLibComponents.BUCKET_CONTENT, class_9279.field_49302);
        if (customdata.method_57450(tagName)) {
            return customdata.method_57461().method_10558(tagName);
        }
        return null;
    }

    private static class_1799 setTagContent(class_1799 itemStack, String tagName, String tagContent) {
        class_1799 result = itemStack.method_7972();
        class_9279 customdata = result.method_57825(BucketLibComponents.BUCKET_CONTENT, class_9279.field_49302);
        class_2487 nbt = customdata.method_57461();
        nbt.method_10582(tagName, tagContent);
        result.method_57379(BucketLibComponents.BUCKET_CONTENT, class_9279.method_57456(nbt));
        return result;
    }

    private static class_1799 removeTagContentNoCopy(class_1799 itemStack, String tagName) {
        class_9279 customdata = itemStack.method_57825(BucketLibComponents.BUCKET_CONTENT, class_9279.field_49302);
        class_2487 nbt = customdata.method_57461();
        if (nbt.method_10545(tagName)) {
            nbt.method_10551(tagName);
            if (nbt.method_33133()) {
                itemStack.method_57381(BucketLibComponents.BUCKET_CONTENT);
            } else {
                itemStack.method_57379(BucketLibComponents.BUCKET_CONTENT, class_9279.method_57456(nbt));
            }
        }
        return itemStack;
    }

    private static class_1799 removeTagContent(class_1799 itemStack, String tagName) {
        return removeTagContentNoCopy(itemStack.method_7972(), tagName);
    }

    public static boolean containsContent(class_1799 itemStack) {
        return containsTagContent(itemStack, "BucketContent");
    }

    public static class_2960 getContent(class_1799 itemStack) {
        String content = getContentString(itemStack);
        if (content != null) {
            return class_2960.method_60654(content);
        }
        return null;
    }

    public static String getContentString(class_1799 itemStack) {
        return getTagContent(itemStack, "BucketContent");
    }

    public static class_1799 addContent(class_1799 itemStack, class_2960 content) {
        return setTagContent(itemStack, "BucketContent", content.toString());
    }

    public static void removeContentNoCopy(class_1799 itemStack, class_3218 level, @Nullable class_1657 player, boolean damage) {
        class_1799 emptyStack = removeTagContentNoCopy(itemStack, "BucketContent");
        if (damage) damageByOne(emptyStack, level, player);
    }

    private static class_1799 removeContent(class_1799 itemStack, class_3218 level, @Nullable class_1657 player, boolean damage) {
        class_1799 emptyStack = removeTagContent(itemStack, "BucketContent");
        if (damage) damageByOne(emptyStack, level, player);
        return emptyStack;
    }

    public static boolean containsMilk(class_1799 itemStack) {
        class_2960 bucketContent = getContent(itemStack);
        if (bucketContent != null && bucketContent.equals(MILK_LOCATION)) {
            return true;
        }
        if (Services.FLUID.hasMilkFluid()) {
            return getFluid(itemStack) == Services.FLUID.getMilkFluid();
        }
        return false;
    }

    public static class_1799 addMilk(class_1799 itemStack) {
        class_1799 filledStack = itemStack;
        if (Services.FLUID.hasMilkFluid()) {
            filledStack = addFluid(filledStack, Services.FLUID.getMilkFluid());
        }
        return addContent(filledStack, MILK_LOCATION);
    }

    public static class_1799 removeMilk(class_1799 itemStack, class_3218 level, @Nullable class_1657 player) {
        return removeFluid(itemStack, level, player);
    }

    public static boolean containsFluid(class_1799 itemStack) {
        return getFluid(itemStack) != class_3612.field_15906;
    }

    public static class_3611 getFluid(class_1799 itemStack) {
        return Services.FLUID.getContainedFluid(itemStack);
    }

    public static class_1799 addFluid(class_1799 itemStack, class_3611 fluid) {
        return Services.FLUID.addFluid(itemStack, fluid);
    }

    public static class_1799 removeFluid(class_1799 itemStack, class_3218 level, @Nullable class_1657 player) {
        AtomicReference<class_1799> resultItemStack = new AtomicReference<>(itemStack.method_7972());
        if (containsMilk(itemStack)) {
            resultItemStack.set(removeContent(resultItemStack.get(), level, player, !containsFluid(resultItemStack.get())));
        }
        return Services.FLUID.removeFluid(resultItemStack.get(), level, player);
    }

    public static boolean containsEntityType(class_1799 itemStack) {
        return containsTagContent(itemStack, "EntityType");
    }

    public static class_1299<?> getEntityType(class_1799 itemStack) {
        String content = getEntityTypeString(itemStack);
        if (content != null) {
            return Services.REGISTRY.getEntityType(class_2960.method_60654(content));
        }
        return null;
    }

    public static String getEntityTypeString(class_1799 itemStack) {
        return getTagContent(itemStack, "EntityType");
    }

    public static class_1799 addEntityType(class_1799 itemStack, class_1299<?> entityType) {
        return setTagContent(itemStack, "EntityType", Services.REGISTRY.getEntityTypeLocation(entityType).toString());
    }

    public static class_1799 removeEntityType(class_1799 itemStack, class_3218 level, @Nullable class_1657 player, boolean damage) {
        class_1799 emptyStack = removeTagContent(itemStack, "EntityType");
        emptyStack.method_57381(class_9334.field_49610); //remove entity data
        if (damage) damageByOne(emptyStack, level, player);
        return emptyStack;
    }

    public static boolean containsBlock(class_1799 itemStack) {
        return containsContent(itemStack) && !containsMilk(itemStack);
    }

    public static class_2248 getBlock(class_1799 itemStack) {
        if (!containsMilk(itemStack)) {
            class_2960 content = getContent(itemStack);
            if (content != null) {
                return Services.REGISTRY.getBlock(content);
            }
        }
        return null;
    }

    public static class_1799 addBlock(class_1799 itemStack, class_2248 block) {
        class_2960 blockLocation = Services.REGISTRY.getBlockLocation(block);
        if (blockLocation != null) {
            return addContent(itemStack, blockLocation);
        }
        return itemStack.method_7972();
    }

    public static class_1799 removeBlock(class_1799 itemStack, class_3218 level, @Nullable class_1657 player, boolean damage) {
        if (!containsMilk(itemStack)) {
            return removeContent(itemStack, level, player, damage);
        }
        return itemStack.method_7972();
    }

}
