/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.item;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class UniversalBucketDispenseBehaviour
extends DefaultDispenseItemBehavior {
    private static final UniversalBucketDispenseBehaviour INSTANCE = new UniversalBucketDispenseBehaviour();
    private final DefaultDispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior();

    public static UniversalBucketDispenseBehaviour getInstance() {
        return INSTANCE;
    }

    private UniversalBucketDispenseBehaviour() {
    }

    @Nonnull
    public ItemStack execute(@Nonnull BlockSource source, @Nonnull ItemStack stack) {
        if (stack.getItem() instanceof UniversalBucketItem) {
            if (BucketLibUtil.isEmpty(stack)) {
                return this.fillBucket(source, stack);
            }
            return this.emptyBucket(source, stack);
        }
        return Services.FLUID.dispenseFluidContainer(source, stack);
    }

    private ItemStack fillBucket(@Nonnull BlockSource source, @Nonnull ItemStack stack) {
        BucketPickup bucketPickup;
        ItemStack vanillaStack;
        UniversalBucketItem universalBucketItem;
        Item item;
        BlockPos pickupPosition;
        ServerLevel level = source.level();
        BlockState blockState = level.getBlockState(pickupPosition = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING)));
        RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(blockState.getBlock());
        if (bucketBlock != null && (item = stack.getItem()) instanceof UniversalBucketItem && (universalBucketItem = (UniversalBucketItem)item).canHoldBlock(bucketBlock.block()) && (item = bucketBlock.block()) instanceof BucketPickup && !(vanillaStack = (bucketPickup = (BucketPickup)item).pickupBlock(null, (LevelAccessor)level, pickupPosition, blockState)).isEmpty()) {
            if (stack.getCount() == 1) {
                return BucketLibUtil.addBlock(stack, bucketBlock.block());
            }
            ItemStack usedStack = stack.copy();
            usedStack.setCount(1);
            ItemStack resultStack = BucketLibUtil.addBlock(usedStack, bucketBlock.block());
            if (stack.getCount() == 1) {
                return resultStack;
            }
            if (!source.blockEntity().insertItem(resultStack).isEmpty()) {
                this.dispenseBehavior.dispense(source, resultStack);
            }
            ItemStack stackCopy = stack.copy();
            stackCopy.shrink(1);
            return stackCopy;
        }
        return Services.FLUID.dispenseFluidContainer(source, stack);
    }

    private ItemStack emptyBucket(@Nonnull BlockSource source, @Nonnull ItemStack stack) {
        Item dispensibleContainerItem2;
        ServerLevel level = source.level();
        BlockPos placePosition = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
        if (BucketLibUtil.containsBlock(stack)) {
            DispensibleContainerItem dispensibleContainerItem2;
            Item item;
            Block placeBlock = BucketLibUtil.getBlock(stack);
            if (placeBlock != null && (item = placeBlock.asItem()) instanceof DispensibleContainerItem && (dispensibleContainerItem2 = (DispensibleContainerItem)item).emptyContents(null, (Level)level, placePosition, null)) {
                return BucketLibUtil.removeBlock(stack, level, null, true);
            }
        } else if (BucketLibUtil.containsEntityType(stack) && (dispensibleContainerItem2 = stack.getItem()) instanceof UniversalBucketItem) {
            UniversalBucketItem bucketItem = (UniversalBucketItem)dispensibleContainerItem2;
            if (BucketLibUtil.containsFluid(stack)) {
                ItemStack stackWithoutEntity = BucketLibUtil.removeEntityData(stack.copy(), level, null, false);
                ItemStack fluidResult = Services.FLUID.dispenseFluidContainer(source, stackWithoutEntity);
                bucketItem.spawnEntityFromBucket(null, (Level)source.level(), stack, placePosition, false);
                return fluidResult;
            }
            return bucketItem.spawnEntityFromBucket(null, (Level)source.level(), stack, placePosition, true);
        }
        return Services.FLUID.dispenseFluidContainer(source, stack);
    }
}

