/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.item;

import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.util.BucketLibUtil;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;

public class UniversalBucketFluidHandler
extends FluidHandlerItemStack {
    public UniversalBucketFluidHandler(@Nonnull ItemStack container) {
        super(BucketLibMod.FLUID_COMPONENT, container, 1000);
    }

    @Nonnull
    public FluidStack getFluid() {
        ResourceLocation bucketContent;
        FluidStack fluidStack = super.getFluid();
        if (fluidStack.isEmpty() && NeoForgeMod.MILK.isBound() && (bucketContent = BucketLibUtil.getContent(this.container)) != null && bucketContent.equals((Object)BucketLibUtil.MILK_LOCATION)) {
            fluidStack = new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000);
            this.setFluid(fluidStack);
        }
        return fluidStack;
    }

    public int fill(@Nonnull FluidStack resource, @Nonnull IFluidHandler.FluidAction doFill) {
        if (BucketLibUtil.containsMilk(this.getContainer())) {
            return 0;
        }
        if (resource.getAmount() < this.capacity) {
            return 0;
        }
        return super.fill(resource, doFill);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, @Nonnull IFluidHandler.FluidAction action) {
        if (BucketLibUtil.containsEntityType(this.getContainer())) {
            return FluidStack.EMPTY;
        }
        if (!NeoForgeMod.MILK.isBound() && BucketLibUtil.containsMilk(this.getContainer())) {
            return FluidStack.EMPTY;
        }
        if (maxDrain < this.capacity) {
            return FluidStack.EMPTY;
        }
        if (action == IFluidHandler.FluidAction.EXECUTE && BucketLibUtil.isAffectedByInfinityEnchantment(this.container)) {
            return super.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
        }
        return super.drain(maxDrain, action);
    }

    protected void setContainerToEmpty() {
        boolean wasCracked = false;
        Item item = this.container.getItem();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem bucketItem = (UniversalBucketItem)item;
            wasCracked = bucketItem.isCracked(this.container);
        }
        super.setContainerToEmpty();
        if (wasCracked) {
            this.container.shrink(1);
        } else {
            if (BucketLibUtil.containsContent(this.container)) {
                BucketLibUtil.removeContentNoCopy(this.container, null, null, false);
            }
            BucketLibUtil.damageByOne(this.container, null);
        }
    }

    public boolean canFillFluidType(@Nonnull FluidStack fluid) {
        Item item = this.container.getItem();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem bucketItem = (UniversalBucketItem)item;
            return fluid.getFluid() != Fluids.EMPTY && bucketItem.canHoldFluid(fluid.getFluid());
        }
        return super.canFillFluidType(fluid);
    }
}

