/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class BlockIngredient
implements ICustomIngredient {
    protected final Block block;
    protected final TagKey<Block> tag;
    private Holder<Item>[] matchingStacks;
    public static final MapCodec<BlockIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.optionalFieldOf("block").forGetter(i -> Optional.of(BuiltInRegistries.BLOCK.getKey((Object)i.block))), (App)TagKey.codec((ResourceKey)BuiltInRegistries.BLOCK.key()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))).apply((Applicative)builder, BlockIngredient::new));
    public static final IngredientType<BlockIngredient> TYPE = new IngredientType(CODEC);

    private BlockIngredient(Block block, TagKey<Block> tag) {
        this.block = block;
        this.tag = tag;
    }

    public BlockIngredient(Optional<ResourceLocation> blockOptional, Optional<TagKey<Block>> tagOptional) {
        this(blockOptional.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0)).filter(Optional::isPresent).map(itemReference -> (Block)((Holder.Reference)itemReference.get()).value()).orElse(null), (TagKey<Block>)((TagKey)tagOptional.orElse(null)));
    }

    public BlockIngredient(Block block) {
        this(block, null);
    }

    public BlockIngredient(TagKey<Block> tag) {
        this(null, tag);
    }

    public boolean test(@Nonnull ItemStack itemStack) {
        List<RegistryUtil.BucketBlock> bucketBlocks;
        if (itemStack.isEmpty()) {
            return false;
        }
        if (this.block != null) {
            RegistryUtil.BucketBlock bucketBlock2 = RegistryUtil.getBucketBlock(this.block);
            if (bucketBlock2 == null) {
                return false;
            }
            bucketBlocks = List.of(bucketBlock2);
        } else {
            bucketBlocks = RegistryUtil.getBucketBlocks().stream().filter(bucketBlock -> bucketBlock.block().defaultBlockState().is(this.tag)).toList();
        }
        Iterator<RegistryUtil.BucketBlock> iterator = bucketBlocks.iterator();
        if (iterator.hasNext()) {
            RegistryUtil.BucketBlock bucketBlock3 = iterator.next();
            if (itemStack.getItem() == bucketBlock3.bucketItem()) {
                return true;
            }
            return BucketLibUtil.getBlock(itemStack) == bucketBlock3.block();
        }
        return false;
    }

    @Nonnull
    public Stream<Holder<Item>> items() {
        if (this.matchingStacks == null) {
            ArrayList<Holder> stacks = new ArrayList<Holder>();
            ArrayList<Block> blocks = new ArrayList<Block>();
            if (this.tag != null) {
                BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag).forEach(block -> blocks.add((Block)block.value()));
            } else if (this.block != null) {
                blocks.add(this.block);
            }
            List<RegistryUtil.BucketBlock> bucketBlocks = RegistryUtil.getBucketBlocks().stream().filter(bucketBlock -> blocks.contains(bucketBlock.block())).toList();
            for (RegistryUtil.BucketBlock bucketBlock2 : bucketBlocks) {
                stacks.add(Holder.direct((Object)bucketBlock2.bucketItem()));
            }
            for (RegistryUtil.BucketBlock bucketBlock2 : bucketBlocks) {
                BucketLibMod.getRegisteredBuckets().forEach(bucket -> {
                    if (bucket.canHoldBlock(bucketBlock2.block())) {
                        stacks.add(Holder.direct((Object)bucket));
                    }
                });
            }
            this.matchingStacks = stacks.toArray(new Holder[0]);
        }
        return Stream.of(this.matchingStacks);
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IngredientType<?> getType() {
        return TYPE;
    }
}

