/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class EmptyIngredient
implements ICustomIngredient {
    protected Item item;
    protected TagKey<Item> tag;
    private Holder<Item>[] matchingStacks;
    public static final MapCodec<EmptyIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.optionalFieldOf("item").forGetter(i -> Optional.of(BuiltInRegistries.ITEM.getKey((Object)i.item))), (App)TagKey.codec((ResourceKey)BuiltInRegistries.ITEM.key()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))).apply((Applicative)builder, EmptyIngredient::new));
    public static final IngredientType<EmptyIngredient> TYPE = new IngredientType(CODEC);

    public EmptyIngredient(Item item, TagKey<Item> tag) {
        this.item = item;
        this.tag = tag;
    }

    public EmptyIngredient(Item item) {
        this(item, null);
    }

    public EmptyIngredient(TagKey<Item> tag) {
        this(null, tag);
    }

    public EmptyIngredient() {
        this((Item)null, null);
    }

    public EmptyIngredient(Optional<ResourceLocation> itemOptional, Optional<TagKey<Item>> tagOptional) {
        this(itemOptional.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).filter(Optional::isPresent).map(itemReference -> (Item)((Holder.Reference)itemReference.get()).value()).orElse(null), (TagKey<Item>)((TagKey)tagOptional.orElse(null)));
    }

    public boolean test(@Nonnull ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        if (this.item == null && this.tag == null && itemStack.getItem() == Items.BUCKET) {
            return true;
        }
        if (this.item != null && itemStack.getItem() == this.item || this.tag != null && itemStack.is(this.tag) || this.item == null && this.tag == null && itemStack.getItem() instanceof UniversalBucketItem) {
            return BucketLibUtil.isEmpty(itemStack);
        }
        return false;
    }

    @Nonnull
    public Stream<Holder<Item>> items() {
        if (this.matchingStacks == null) {
            ArrayList<Holder> stacks = new ArrayList<Holder>();
            if (this.item == null && this.tag == null) {
                stacks.add(Holder.direct((Object)Items.BUCKET));
            }
            BucketLibMod.getRegisteredBuckets().forEach(universalBucketItem -> {
                Holder universalBucketItemStack = Holder.direct((Object)universalBucketItem);
                if (this.item != null && universalBucketItem == this.item || this.tag != null && universalBucketItemStack.is(this.tag) || this.item == null && this.tag == null) {
                    stacks.add(universalBucketItemStack);
                }
            });
            this.matchingStacks = stacks.toArray(new Holder[0]);
        }
        return Stream.of(this.matchingStacks);
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IngredientType<?> getType() {
        return TYPE;
    }
}

