/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ArmorDyeRecipe;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingRecipe.class})
public interface CraftingRecipeMixin {
    @Inject(at={@At(value="RETURN")}, method={"getRemainingItems"}, cancellable=true)
    default public void getRemainingItems(CraftingInput craftingInput, CallbackInfoReturnable<NonNullList<ItemStack>> cir) {
        if (this instanceof ArmorDyeRecipe) {
            NonNullList list = (NonNullList)cir.getReturnValue();
            boolean changed = false;
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = (ItemStack)list.get(i);
                if (!(stack.getItem() instanceof UniversalBucketItem)) continue;
                list.set(i, (Object)ItemStack.EMPTY);
                changed = true;
            }
            if (changed) {
                cir.setReturnValue((Object)list);
            }
        }
    }
}

