/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.platform.Services;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.entity.FuelValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={UniversalBucketItem.class}, remap=false)
public class NeoforgeUniversalBucketItemMixin
extends Item {
    public NeoforgeUniversalBucketItemMixin(Item.Properties properties) {
        super(properties);
    }

    public int getBurnTime(@NotNull ItemStack itemStack, @Nullable RecipeType<?> recipeType, @NotNull FuelValues fuelValues) {
        Item item = itemStack.getItem();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem universalBucketItem = (UniversalBucketItem)item;
            return universalBucketItem.getBucketBurnTime(itemStack, recipeType);
        }
        return super.getBurnTime(itemStack, recipeType, fuelValues);
    }

    public boolean isPrimaryItemFor(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.INFINITY) && Services.CONFIG.isInfinityEnchantmentEnabled() && stack.getEnchantmentLevel((Holder)((HolderLookup.RegistryLookup)VanillaRegistries.createLookup().lookup(Registries.ENCHANTMENT).get()).getOrThrow(Enchantments.INFINITY)) <= 0 && Services.FLUID.getContainedFluid(stack).defaultFluidState().is(BucketLibTags.Fluids.INFINITY_ENCHANTABLE)) {
            return true;
        }
        return super.isPrimaryItemFor(stack, enchantment);
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return stack.isDamageableItem();
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        return stack.getMaxDamage();
    }
}

