/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.platform;

import de.cech12.bucketlib.platform.services.IFluidHelper;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.DispenseFluidContainer;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class NeoforgeFluidHelper
implements IFluidHelper {
    private static final DispenseFluidContainer dispenseFluidBehavior = DispenseFluidContainer.getInstance();

    @Override
    public Component getFluidDescription(Fluid fluid) {
        return fluid.getFluidType().getDescription();
    }

    @Override
    public int getFluidTemperature(Fluid fluid) {
        return fluid.getFluidType().getTemperature();
    }

    @Override
    public boolean hasMilkFluid() {
        return NeoForgeMod.MILK.isBound();
    }

    @Override
    public Fluid getMilkFluid() {
        return (Fluid)NeoForgeMod.MILK.get();
    }

    @Override
    public ItemStack dispenseFluidContainer(BlockSource source, ItemStack stack) {
        return dispenseFluidBehavior.execute(source, stack);
    }

    @Override
    public Fluid getContainedFluid(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).map(fluidHandler -> fluidHandler.getFluidInTank(0)).orElse(FluidStack.EMPTY).getFluid();
    }

    @Override
    public ItemStack addFluid(ItemStack stack, Fluid fluid) {
        AtomicReference<ItemStack> resultItemStack = new AtomicReference<ItemStack>(stack.copy());
        FluidUtil.getFluidHandler((ItemStack)resultItemStack.get()).ifPresent(fluidHandler -> {
            fluidHandler.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            resultItemStack.set(fluidHandler.getContainer());
        });
        return resultItemStack.get();
    }

    @Override
    public ItemStack removeFluid(ItemStack stack, ServerLevel level, @Nullable Player player) {
        AtomicReference<ItemStack> resultItemStack = new AtomicReference<ItemStack>(stack.copy());
        FluidUtil.getFluidHandler((ItemStack)resultItemStack.get()).ifPresent(fluidHandler -> {
            fluidHandler.drain(new FluidStack(fluidHandler.getFluidInTank(0).getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
            resultItemStack.set(fluidHandler.getContainer());
        });
        return resultItemStack.get();
    }

    @Override
    public Tuple<Boolean, ItemStack> tryPickUpFluid(ItemStack stack, Player player, Level level, InteractionHand interactionHand, BlockPos pos, Direction direction) {
        FluidActionResult fluidActionResult = FluidUtil.tryPickUpFluid((ItemStack)stack, (Player)player, (Level)level, (BlockPos)pos, (Direction)direction);
        return new Tuple((Object)fluidActionResult.isSuccess(), (Object)fluidActionResult.getResult());
    }

    @Override
    public Tuple<Boolean, ItemStack> tryPlaceFluid(ItemStack stack, Player player, Level level, InteractionHand interactionHand, BlockPos pos) {
        FluidStack fluidStack = FluidUtil.getFluidHandler((ItemStack)stack).map(fluidHandler -> fluidHandler.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        FluidActionResult fluidActionResult = FluidUtil.tryPlaceFluid((Player)player, (Level)level, (InteractionHand)interactionHand, (BlockPos)pos, (ItemStack)stack, (FluidStack)fluidStack);
        return new Tuple((Object)fluidActionResult.isSuccess(), (Object)fluidActionResult.getResult());
    }

    @Override
    public void curePotionEffects(LivingEntity entity, ItemStack curativeItem) {
        entity.removeAllEffects();
    }
}

