/*
 * Decompiled with CFR 0.152.
 */
package mod.cobblepals.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelCobblePal<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"cobblepals", (String)"model_cobble_pal"), "main");
    public final ModelPart legL;
    public final ModelPart legR;
    public final ModelPart armL;
    public final ModelPart armR;
    public final ModelPart body;

    public ModelCobblePal(ModelPart root) {
        this.legL = root.getChild("legL");
        this.legR = root.getChild("legR");
        this.armL = root.getChild("armL");
        this.armR = root.getChild("armR");
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition legL = partdefinition.addOrReplaceChild("legL", CubeListBuilder.create().texOffs(28, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)21.0f, (float)0.0f));
        PartDefinition legR = partdefinition.addOrReplaceChild("legR", CubeListBuilder.create().texOffs(28, 39).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)21.0f, (float)0.0f));
        PartDefinition armL = partdefinition.addOrReplaceChild("armL", CubeListBuilder.create(), PartPose.offset((float)-8.0f, (float)13.0f, (float)0.0f));
        PartDefinition armL_r1 = armL.addOrReplaceChild("armL_r1", CubeListBuilder.create().texOffs(0, 32).addBox(-1.0f, -3.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition armR = partdefinition.addOrReplaceChild("armR", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)12.0f, (float)0.0f));
        PartDefinition armR_r1 = armR.addOrReplaceChild("armR_r1", CubeListBuilder.create().texOffs(14, 32).addBox(-1.0f, -3.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.legL.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.legR.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.armL.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.armR.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.legR.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.armR.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.legL.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.armL.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

