/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.item;

import java.util.List;
import net.mcreator.createstuffadditions.procedures.BlazingAxeBlockDestroyedWithToolProcedure;
import net.mcreator.createstuffadditions.procedures.BlazingPickaxeLivingEntityIsHitWithToolProcedure;
import net.mcreator.createstuffadditions.procedures.LocalizationHandlerProcedure;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlazingAxeItem
extends AxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 450;
        }

        public float getSpeed() {
            return 12.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
        }

        public int getEnchantmentValue() {
            return 2;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GOLD_INGOT), new ItemStack((ItemLike)Items.BLAZE_POWDER)});
        }
    };

    public BlazingAxeItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)7.5f, (float)-3.0f)));
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        boolean retval = super.mineBlock(itemstack, world, blockstate, pos, entity);
        BlazingAxeBlockDestroyedWithToolProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity, itemstack);
        return retval;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        BlazingPickaxeLivingEntityIsHitWithToolProcedure.execute((Entity)entity, itemstack);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        if (Screen.hasShiftDown()) {
            list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.holdshift").getString().replace("\u00a77", "\u00a7f")));
            list.add((Component)Component.literal((String)" "));
            list.addAll(LocalizationHandlerProcedure.execute(Component.translatable((String)"item_desc.blazing_tools.desc").getString(), 0));
            list.add((Component)Component.literal((String)" "));
            list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.used").getString()));
            list.addAll(LocalizationHandlerProcedure.execute(Component.translatable((String)"item_desc.blazing_tools.desc2").getString(), 1));
        } else {
            list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.holdshift").getString()));
        }
    }
}

