/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.model.light.smooth;

import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

enum AoNeighborInfo {
    DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, 0.5f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = Mth.clamp((float)z, (float)0.0f, (float)1.0f);
            float v = Mth.clamp((float)(1.0f - x), (float)0.0f, (float)1.0f);
            out[0] = v * u;
            out[1] = v * (1.0f - u);
            out[2] = (1.0f - v) * (1.0f - u);
            out[3] = (1.0f - v) * u;
        }

        @Override
        public void mapCorners(int[] lm0, float[] ao0, int[] lm1, float[] ao1) {
            lm1[0] = lm0[0];
            lm1[1] = lm0[1];
            lm1[2] = lm0[2];
            lm1[3] = lm0[3];
            ao1[0] = ao0[0];
            ao1[1] = ao0[1];
            ao1[2] = ao0[2];
            ao1[3] = ao0[3];
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return Mth.clamp((float)y, (float)0.0f, (float)1.0f);
        }
    }
    ,
    UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, 1.0f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = Mth.clamp((float)z, (float)0.0f, (float)1.0f);
            float v = Mth.clamp((float)x, (float)0.0f, (float)1.0f);
            out[0] = v * u;
            out[1] = v * (1.0f - u);
            out[2] = (1.0f - v) * (1.0f - u);
            out[3] = (1.0f - v) * u;
        }

        @Override
        public void mapCorners(int[] lm0, float[] ao0, int[] lm1, float[] ao1) {
            lm1[2] = lm0[0];
            lm1[3] = lm0[1];
            lm1[0] = lm0[2];
            lm1[1] = lm0[3];
            ao1[2] = ao0[0];
            ao1[3] = ao0[1];
            ao1[0] = ao0[2];
            ao1[1] = ao0[3];
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return 1.0f - Mth.clamp((float)y, (float)0.0f, (float)1.0f);
        }
    }
    ,
    NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, 0.8f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = Mth.clamp((float)(1.0f - x), (float)0.0f, (float)1.0f);
            float v = Mth.clamp((float)y, (float)0.0f, (float)1.0f);
            out[0] = v * u;
            out[1] = v * (1.0f - u);
            out[2] = (1.0f - v) * (1.0f - u);
            out[3] = (1.0f - v) * u;
        }

        @Override
        public void mapCorners(int[] lm0, float[] ao0, int[] lm1, float[] ao1) {
            lm1[3] = lm0[0];
            lm1[0] = lm0[1];
            lm1[1] = lm0[2];
            lm1[2] = lm0[3];
            ao1[3] = ao0[0];
            ao1[0] = ao0[1];
            ao1[1] = ao0[2];
            ao1[2] = ao0[3];
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return Mth.clamp((float)z, (float)0.0f, (float)1.0f);
        }
    }
    ,
    SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, 0.8f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = Mth.clamp((float)y, (float)0.0f, (float)1.0f);
            float v = Mth.clamp((float)(1.0f - x), (float)0.0f, (float)1.0f);
            out[0] = u * v;
            out[1] = (1.0f - u) * v;
            out[2] = (1.0f - u) * (1.0f - v);
            out[3] = u * (1.0f - v);
        }

        @Override
        public void mapCorners(int[] lm0, float[] ao0, int[] lm1, float[] ao1) {
            lm1[0] = lm0[0];
            lm1[1] = lm0[1];
            lm1[2] = lm0[2];
            lm1[3] = lm0[3];
            ao1[0] = ao0[0];
            ao1[1] = ao0[1];
            ao1[2] = ao0[2];
            ao1[3] = ao0[3];
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return 1.0f - Mth.clamp((float)z, (float)0.0f, (float)1.0f);
        }
    }
    ,
    WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, 0.6f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = Mth.clamp((float)z, (float)0.0f, (float)1.0f);
            float v = Mth.clamp((float)y, (float)0.0f, (float)1.0f);
            out[0] = v * u;
            out[1] = v * (1.0f - u);
            out[2] = (1.0f - v) * (1.0f - u);
            out[3] = (1.0f - v) * u;
        }

        @Override
        public void mapCorners(int[] lm0, float[] ao0, int[] lm1, float[] ao1) {
            lm1[3] = lm0[0];
            lm1[0] = lm0[1];
            lm1[1] = lm0[2];
            lm1[2] = lm0[3];
            ao1[3] = ao0[0];
            ao1[0] = ao0[1];
            ao1[1] = ao0[2];
            ao1[2] = ao0[3];
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return Mth.clamp((float)x, (float)0.0f, (float)1.0f);
        }
    }
    ,
    EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, 0.6f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = Mth.clamp((float)z, (float)0.0f, (float)1.0f);
            float v = Mth.clamp((float)(1.0f - y), (float)0.0f, (float)1.0f);
            out[0] = v * u;
            out[1] = v * (1.0f - u);
            out[2] = (1.0f - v) * (1.0f - u);
            out[3] = (1.0f - v) * u;
        }

        @Override
        public void mapCorners(int[] lm0, float[] ao0, int[] lm1, float[] ao1) {
            lm1[1] = lm0[0];
            lm1[2] = lm0[1];
            lm1[3] = lm0[2];
            lm1[0] = lm0[3];
            ao1[1] = ao0[0];
            ao1[2] = ao0[1];
            ao1[3] = ao0[2];
            ao1[0] = ao0[3];
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return 1.0f - Mth.clamp((float)x, (float)0.0f, (float)1.0f);
        }
    };

    public final Direction[] faces;
    public final float strength;
    private static final AoNeighborInfo[] VALUES;

    private AoNeighborInfo(Direction[] directions, float strength) {
        this.faces = directions;
        this.strength = strength;
    }

    public abstract void calculateCornerWeights(float var1, float var2, float var3, float[] var4);

    public abstract void mapCorners(int[] var1, float[] var2, int[] var3, float[] var4);

    public abstract float getDepth(float var1, float var2, float var3);

    public static AoNeighborInfo get(Direction direction) {
        return VALUES[direction.get3DDataValue()];
    }

    static {
        VALUES = AoNeighborInfo.values();
    }
}

