/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.AlignableNormal;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.CameraMovement;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.GeometryPlanes;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalList;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.NormalPlanes;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.SortTriggering;
import net.minecraft.core.SectionPos;
import org.joml.Vector3fc;

class GFNITriggers
implements SortTriggering.SectionTriggers<DynamicData> {
    private Object2ReferenceOpenHashMap<Vector3fc, NormalList> normalLists = new Object2ReferenceOpenHashMap();

    GFNITriggers() {
    }

    int getUniqueNormalCount() {
        return this.normalLists.size();
    }

    @Override
    public void processTriggers(SortTriggering ts, CameraMovement movement) {
        for (NormalList normalList : this.normalLists.values()) {
            normalList.processMovement(ts, movement);
        }
    }

    private void addSectionInNewNormalLists(DynamicData dynamicData, NormalPlanes normalPlanes) {
        AlignableNormal normal = normalPlanes.normal;
        NormalList normalList = (NormalList)this.normalLists.get((Object)normal);
        if (normalList == null) {
            normalList = new NormalList(normal);
            this.normalLists.put((Object)normal, (Object)normalList);
            normalList.addSection(normalPlanes, normalPlanes.sectionPos.asLong());
        }
    }

    private boolean removeSectionFromList(NormalList normalList, long sectionPos) {
        normalList.removeSection(sectionPos);
        return normalList.isEmpty();
    }

    @Override
    public void removeSection(long sectionPos, TranslucentData data) {
        this.normalLists.values().removeIf(normalList -> this.removeSectionFromList((NormalList)normalList, sectionPos));
    }

    @Override
    public void integrateSection(SortTriggering ts, SectionPos pos, DynamicData data, CameraMovement movement) {
        Collection<NormalPlanes> collection;
        long sectionPos = pos.asLong();
        GeometryPlanes geometryPlanes = data.getGeometryPlanes();
        ObjectIterator iterator = this.normalLists.values().iterator();
        while (iterator.hasNext()) {
            NormalList normalList = (NormalList)iterator.next();
            NormalPlanes normalPlanes = geometryPlanes.getPlanesForNormal(normalList);
            if (normalList.hasSection(sectionPos)) {
                if (normalPlanes == null) {
                    if (!this.removeSectionFromList(normalList, sectionPos)) continue;
                    iterator.remove();
                    continue;
                }
                normalList.updateSection(normalPlanes, sectionPos);
                continue;
            }
            if (normalPlanes == null) continue;
            normalList.addSection(normalPlanes, sectionPos);
        }
        NormalPlanes[] aligned = geometryPlanes.getAligned();
        if (aligned != null) {
            for (NormalPlanes normalPlane : aligned) {
                if (normalPlane == null) continue;
                this.addSectionInNewNormalLists(data, normalPlane);
            }
        }
        if ((collection = geometryPlanes.getUnaligned()) != null) {
            for (NormalPlanes normalPlane : collection) {
                this.addSectionInNewNormalLists(data, normalPlane);
            }
        }
        data.discardGeometryPlanes();
        if (movement.hasChanged()) {
            for (NormalList normalList : this.normalLists.values()) {
                normalList.processCatchup(ts, movement, sectionPos);
            }
        }
    }
}

