/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.textures.scan;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.NativeImage;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.SpriteContentsExtension;
import net.caffeinemc.mods.sodium.client.util.NativeImageHelper;
import net.minecraft.client.renderer.texture.SpriteContents;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={SpriteContents.class})
public class SpriteContentsMixin
implements SpriteContentsExtension {
    @Mutable
    @Shadow
    @Final
    private NativeImage originalImage;
    @Unique
    public boolean sodium$hasTransparentPixels = false;
    @Unique
    public boolean sodium$hasTranslucentPixels = false;

    @WrapOperation(method={"<init>"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/texture/SpriteContents;originalImage:Lcom/mojang/blaze3d/platform/NativeImage;", opcode=181)})
    private void sodium$beforeGenerateMipLevels(SpriteContents instance, NativeImage nativeImage, Operation<Void> original) {
        this.scanSpriteContents(nativeImage);
        original.call(new Object[]{instance, nativeImage});
    }

    @Unique
    private void scanSpriteContents(NativeImage nativeImage) {
        long ppPixel = NativeImageHelper.getPointerRGBA(nativeImage);
        int pixelCount = nativeImage.getHeight() * nativeImage.getWidth();
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            int color = MemoryUtil.memGetInt((long)(ppPixel + (long)pixelIndex * 4L));
            int alpha = ColorABGR.unpackAlpha(color);
            if (alpha <= 25) {
                this.sodium$hasTransparentPixels = true;
                continue;
            }
            if (alpha >= 255) continue;
            this.sodium$hasTranslucentPixels = true;
        }
        this.sodium$hasTransparentPixels |= this.sodium$hasTranslucentPixels;
    }

    @Override
    public boolean sodium$hasTransparentPixels() {
        return this.sodium$hasTransparentPixels;
    }

    @Override
    public boolean sodium$hasTranslucentPixels() {
        return this.sodium$hasTranslucentPixels;
    }
}

