/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.other;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;

public final class CommonColorFactors {
    private static final Minecraft CLIENT = Objects.requireNonNull(Minecraft.getInstance(), "loaded too early");
    public static final CommonColorFactors SKY_COLOR = new CommonColorFactors();
    public static final CommonColorFactors LIGHTMAP = new CommonColorFactors();
    private static int lastUpdateTick = -1;
    public static float lastRainGradient;
    public static float lastThunderGradient;
    public static int lastLightningTicks;
    public static float rainGradientMultiplier;
    public static float thunderGradientMultiplier;
    private boolean thisInstanceDirty;
    private boolean didTickChange;
    private long lastTime;

    private CommonColorFactors() {
    }

    public static void tick() {
        int tick = CommonColorFactors.CLIENT.player.tickCount;
        if (lastUpdateTick == tick) {
            return;
        }
        lastUpdateTick = tick;
        ClientLevel world = CommonColorFactors.CLIENT.level;
        float tickDelta = CLIENT.getTimer().getGameTimeDeltaPartialTick(false);
        boolean result = false;
        float rainGradient = world.getRainLevel(tickDelta);
        float thunderGradient = world.getThunderLevel(tickDelta);
        int lightningTicks = world.getSkyFlashTime();
        if (rainGradient != lastRainGradient) {
            result = true;
            lastRainGradient = rainGradient;
            rainGradientMultiplier = rainGradient > 0.0f ? 1.0f - rainGradient * 0.75f : 0.0f;
        }
        if (thunderGradient != lastThunderGradient) {
            result = true;
            lastThunderGradient = thunderGradient;
            thunderGradientMultiplier = thunderGradient > 0.0f ? 1.0f - thunderGradient * 0.75f : 0.0f;
        }
        if (lastLightningTicks != lightningTicks) {
            result = true;
            lastLightningTicks = lightningTicks;
        }
        CommonColorFactors.SKY_COLOR.didTickChange = true;
        CommonColorFactors.LIGHTMAP.didTickChange = true;
        if (result) {
            CommonColorFactors.SKY_COLOR.thisInstanceDirty = true;
            CommonColorFactors.LIGHTMAP.thisInstanceDirty = true;
        }
    }

    public boolean isDirty() {
        if (this.thisInstanceDirty) {
            this.thisInstanceDirty = false;
            return true;
        }
        return false;
    }

    public boolean didTickChange() {
        if (this.didTickChange) {
            this.didTickChange = false;
            return true;
        }
        return false;
    }

    public long getTimeDelta() {
        return Math.abs(CommonColorFactors.CLIENT.level.dayTime() - this.lastTime);
    }

    public void updateLastTime() {
        this.lastTime = CommonColorFactors.CLIENT.level.dayTime();
    }
}

