/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class ItemApplicationRecipe
extends ProcessingRecipe<RecipeWrapper> {
    private boolean keepHeldItem;

    public static <T extends ProcessingRecipe<?>> MapCodec<T> codec(AllRecipeTypes recipeTypes) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)ProcessingRecipeSerializer.codec(recipeTypes).forGetter(Function.identity()), (App)Codec.BOOL.optionalFieldOf("keep_held_item", (Object)false).forGetter(r -> {
            boolean bl;
            if (r instanceof ItemApplicationRecipe) {
                ItemApplicationRecipe iar = (ItemApplicationRecipe)r;
                if (iar.keepHeldItem) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        })).apply((Applicative)i, (parent, keepHeldItem) -> {
            if (parent instanceof ItemApplicationRecipe) {
                ItemApplicationRecipe iar = (ItemApplicationRecipe)parent;
                iar.keepHeldItem = keepHeldItem;
            }
            return parent;
        }));
    }

    public ItemApplicationRecipe(AllRecipeTypes type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
        this.keepHeldItem = params.keepHeldItem;
    }

    public boolean matches(RecipeWrapper inv, Level p_77569_2_) {
        return this.getProcessedItem().test(inv.getItem(0)) && this.getRequiredHeldItem().test(inv.getItem(1));
    }

    @Override
    protected int getMaxInputCount() {
        return 2;
    }

    @Override
    protected int getMaxOutputCount() {
        return 4;
    }

    public boolean shouldKeepHeldItem() {
        return this.keepHeldItem;
    }

    public Ingredient getRequiredHeldItem() {
        if (this.ingredients.size() < 2) {
            throw new IllegalStateException("Item Application Recipe: " + this.id.toString() + " has no tool!");
        }
        return (Ingredient)this.ingredients.get(1);
    }

    public Ingredient getProcessedItem() {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("Item Application Recipe: " + this.id.toString() + " has no ingredient!");
        }
        return (Ingredient)this.ingredients.get(0);
    }

    @Override
    public void readAdditional(FriendlyByteBuf buffer) {
        super.readAdditional(buffer);
        this.keepHeldItem = buffer.readBoolean();
    }

    @Override
    public void writeAdditional(FriendlyByteBuf buffer) {
        super.writeAdditional(buffer);
        buffer.writeBoolean(this.keepHeldItem);
    }
}

