/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ProcessingRecipeSerializer<T extends ProcessingRecipe<?>>
implements RecipeSerializer<T> {
    private final ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory;
    public final MapCodec<T> CODEC = AllRecipeTypes.CODEC.dispatchMap(ProcessingRecipe::getRecipeType, AllRecipeTypes::processingCodec);
    public final StreamCodec<RegistryFriendlyByteBuf, T> STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);

    public ProcessingRecipeSerializer(ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory) {
        this.factory = factory;
    }

    public static <T extends ProcessingRecipe<?>> MapCodec<T> codec(AllRecipeTypes recipeTypes) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Ingredient.CODEC, FluidIngredient.CODEC).listOf().fieldOf("ingredients").forGetter(i -> {
            ArrayList list = new ArrayList();
            i.getIngredients().forEach(o -> list.add(Either.left((Object)o)));
            i.getFluidIngredients().forEach(o -> list.add(Either.right((Object)o)));
            return list;
        }), (App)Codec.either((Codec)FluidStack.CODEC, ProcessingOutput.CODEC).listOf().fieldOf("results").forGetter(i -> {
            ArrayList list = new ArrayList();
            i.getFluidResults().forEach(o -> list.add(Either.left((Object)o)));
            i.getRollableResults().forEach(o -> list.add(Either.right((Object)o)));
            return list;
        }), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("processing_time", (Object)0).forGetter(ProcessingRecipe::getProcessingDuration), (App)HeatCondition.CODEC.optionalFieldOf("heat_requirement", (Object)HeatCondition.NONE).forGetter(ProcessingRecipe::getRequiredHeat)).apply((Applicative)instance, (ingredients, results, processingTime, heatRequirement) -> {
            RecipeSerializer<?> patt0$temp = recipeTypes.serializerSupplier.get();
            if (!(patt0$temp instanceof ProcessingRecipeSerializer)) {
                throw new RuntimeException("Not a processing recipe serializer " + String.valueOf(recipeTypes.serializerSupplier.get()));
            }
            ProcessingRecipeSerializer processingRecipeSerializer = (ProcessingRecipeSerializer)patt0$temp;
            ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(processingRecipeSerializer.getFactory(), recipeTypes.id);
            NonNullList ingredientList = NonNullList.create();
            NonNullList fluidIngredientList = NonNullList.create();
            NonNullList processingOutputList = NonNullList.create();
            NonNullList fluidStackOutputList = NonNullList.create();
            for (Either either : ingredients) {
                either.left().ifPresent(arg_0 -> ingredientList.add(arg_0));
                either.right().ifPresent(arg_0 -> fluidIngredientList.add(arg_0));
            }
            for (Either either : results) {
                either.left().ifPresent(arg_0 -> fluidStackOutputList.add(arg_0));
                either.right().ifPresent(arg_0 -> processingOutputList.add(arg_0));
            }
            builder.withItemIngredients((NonNullList<Ingredient>)ingredientList).withItemOutputs((NonNullList<ProcessingOutput>)processingOutputList).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredientList).withFluidOutputs((NonNullList<FluidStack>)fluidStackOutputList).duration((int)processingTime).requiresHeat((HeatCondition)((Object)((Object)heatRequirement)));
            return builder.build();
        }));
    }

    protected void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
        ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)((ProcessingRecipe)recipe).id);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).encode((Object)buffer, ((ProcessingRecipe)recipe).ingredients);
        CatnipStreamCodecBuilders.nonNullList(FluidIngredient.STREAM_CODEC).encode((Object)buffer, ((ProcessingRecipe)recipe).fluidIngredients);
        CatnipStreamCodecBuilders.nonNullList(ProcessingOutput.STREAM_CODEC).encode((Object)buffer, ((ProcessingRecipe)recipe).results);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidStack.STREAM_CODEC).encode((Object)buffer, ((ProcessingRecipe)recipe).fluidResults);
        ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)((ProcessingRecipe)recipe).getProcessingDuration());
        HeatCondition.STREAM_CODEC.encode((Object)buffer, (Object)((ProcessingRecipe)recipe).getRequiredHeat());
        ((ProcessingRecipe)recipe).writeAdditional((FriendlyByteBuf)buffer);
    }

    protected T fromNetwork(RegistryFriendlyByteBuf buffer) {
        ResourceLocation recipeId = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
        NonNullList ingredients = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).decode((Object)buffer);
        NonNullList fluidIngredients = (NonNullList)CatnipStreamCodecBuilders.nonNullList(FluidIngredient.STREAM_CODEC).decode((Object)buffer);
        NonNullList results = (NonNullList)CatnipStreamCodecBuilders.nonNullList(ProcessingOutput.STREAM_CODEC).decode((Object)buffer);
        NonNullList fluidResults = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidStack.STREAM_CODEC).decode((Object)buffer);
        T recipe = new ProcessingRecipeBuilder<T>(this.factory, recipeId).withItemIngredients((NonNullList<Ingredient>)ingredients).withItemOutputs((NonNullList<ProcessingOutput>)results).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withFluidOutputs((NonNullList<FluidStack>)fluidResults).duration((Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer)).requiresHeat((HeatCondition)((Object)HeatCondition.STREAM_CODEC.decode((Object)buffer))).build();
        ((ProcessingRecipe)recipe).readAdditional((FriendlyByteBuf)buffer);
        return recipe;
    }

    public MapCodec<T> codec() {
        return this.CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.STREAM_CODEC;
    }

    public ProcessingRecipeBuilder.ProcessingRecipeFactory<T> getFactory() {
        return this.factory;
    }
}

