/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.simibubi.create.foundation.item.ItemSlots;
import java.util.function.Function;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CreateCodecs {
    public static final Codec<Integer> INT_STR = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)Integer.parseInt(string));
        }
        catch (NumberFormatException ignored) {
            return DataResult.error(() -> "Not an integer: " + string);
        }
    }, String::valueOf);
    public static final Codec<ItemStackHandler> ITEM_STACK_HANDLER = ItemSlots.CODEC.xmap(slots -> slots.toHandler(ItemStackHandler::new), ItemSlots::fromHandler);
    public static final Codec<Double> NON_NEGATIVE_DOUBLE = CreateCodecs.doubleRangeWithMessage(0.0, Double.MAX_VALUE, i -> "Value must be non-negative: " + i);
    public static final Codec<Double> POSITIVE_DOUBLE = CreateCodecs.doubleRangeWithMessage(1.0, Double.MAX_VALUE, i -> "Value must be positive: " + i);

    public static Codec<Integer> boundedIntStr(int min) {
        return INT_STR.validate(i -> i >= min ? DataResult.success((Object)i) : DataResult.error(() -> "Value under minimum of " + min));
    }

    private static Codec<Double> doubleRangeWithMessage(double min, double max, Function<Double, String> errorMessage) {
        return Codec.DOUBLE.validate(i -> i.compareTo(min) >= 0 && i.compareTo(max) <= 0 ? DataResult.success((Object)i) : DataResult.error(() -> (String)errorMessage.apply((Double)i)));
    }
}

