/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class PlayerSkyhookRenderer {
    private static final Set<UUID> hangingPlayers = new HashSet<UUID>();

    public static void updatePlayerList(Collection<UUID> uuids) {
        hangingPlayers.clear();
        hangingPlayers.addAll(uuids);
    }

    public static void beforeSetupAnim(Player player, HumanoidModel<?> model) {
        if (hangingPlayers.contains(player.getUUID())) {
            return;
        }
        model.head.resetPose();
        model.hat.resetPose();
        model.body.resetPose();
        model.leftArm.resetPose();
        model.rightArm.resetPose();
        model.leftLeg.resetPose();
        model.rightLeg.resetPose();
    }

    public static void afterSetupAnim(Player player, HumanoidModel<?> model) {
        if (hangingPlayers.contains(player.getUUID())) {
            PlayerSkyhookRenderer.setHangingPose(model);
        }
    }

    private static void setHangingPose(HumanoidModel<?> model) {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        model.head.x = 0.0f;
        model.hat.x = 0.0f;
        model.body.resetPose();
        model.leftArm.resetPose();
        model.rightArm.resetPose();
        model.leftLeg.resetPose();
        model.rightLeg.resetPose();
        float time = (float)AnimationTickHolder.getTicks((boolean)true) + AnimationTickHolder.getPartialTicks();
        float mainCycle = Mth.sin((float)((float)((double)((time + 10.0f) * 0.3f) / Math.PI)));
        float limbCycle = Mth.sin((float)((float)((double)(time * 0.3f) / Math.PI)));
        float bodySwing = AngleHelper.rad((double)(15.0f + mainCycle * 10.0f));
        float limbSwing = AngleHelper.rad((double)(limbCycle * 15.0f));
        model.body.zRot = bodySwing;
        model.head.zRot = bodySwing;
        model.hat.zRot = bodySwing;
        model.rightArm.y -= 3.0f;
        float offsetX = model.rightArm.x;
        float offsetY = model.rightArm.y;
        float armPivotX = offsetX * Mth.cos((float)bodySwing) - offsetY * Mth.sin((float)bodySwing) + 4.5f;
        float armPivotY = offsetX * Mth.sin((float)bodySwing) + offsetY * Mth.cos((float)bodySwing) + 2.0f;
        model.rightArm.xRot = -AngleHelper.rad((double)150.0);
        model.rightArm.zRot = AngleHelper.rad((double)15.0);
        offsetX = model.leftArm.x;
        offsetY = model.leftArm.y;
        model.leftArm.x = offsetX * Mth.cos((float)bodySwing) - offsetY * Mth.sin((float)bodySwing);
        model.leftArm.y = offsetX * Mth.sin((float)bodySwing) + offsetY * Mth.cos((float)bodySwing);
        model.leftArm.zRot = -AngleHelper.rad((double)20.0) + 0.5f * bodySwing + limbSwing;
        model.rightLeg.y -= 0.2f;
        offsetX = model.rightLeg.x;
        offsetY = model.rightLeg.y;
        model.rightLeg.x = offsetX * Mth.cos((float)bodySwing) - offsetY * Mth.sin((float)bodySwing);
        model.rightLeg.y = offsetX * Mth.sin((float)bodySwing) + offsetY * Mth.cos((float)bodySwing);
        model.rightLeg.xRot = -AngleHelper.rad((double)25.0);
        model.rightLeg.zRot = AngleHelper.rad((double)10.0) + 0.5f * bodySwing + limbSwing;
        model.leftLeg.y -= 0.8f;
        offsetX = model.leftLeg.x;
        offsetY = model.leftLeg.y;
        model.leftLeg.x = offsetX * Mth.cos((float)bodySwing) - offsetY * Mth.sin((float)bodySwing);
        model.leftLeg.y = offsetX * Mth.sin((float)bodySwing) + offsetY * Mth.cos((float)bodySwing);
        model.leftLeg.xRot = AngleHelper.rad((double)10.0);
        model.leftLeg.zRot = -AngleHelper.rad((double)10.0) + 0.5f * bodySwing + limbSwing;
        model.hat.x -= armPivotX;
        model.head.x -= armPivotX;
        model.body.x -= armPivotX;
        model.leftArm.x -= armPivotX;
        model.leftLeg.x -= armPivotX;
        model.rightLeg.x -= armPivotX;
        model.hat.y -= armPivotY;
        model.head.y -= armPivotY;
        model.body.y -= armPivotY;
        model.leftArm.y -= armPivotY;
        model.leftLeg.y -= armPivotY;
        model.rightLeg.y -= armPivotY;
    }
}

