/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.flywheel.light;

import com.simibubi.create.foundation.utility.flywheel.box.Box;
import com.simibubi.create.foundation.utility.flywheel.box.MutableBox;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import org.lwjgl.system.MemoryUtil;

public class LightVolume
implements Box {
    protected final BlockAndTintGetter level;
    protected final MutableBox box = new MutableBox();
    protected MemoryBlock lightData;

    public LightVolume(BlockAndTintGetter level, Box sampleVolume) {
        this.level = level;
        this.setBox(sampleVolume);
        this.lightData = MemoryBlock.malloc((long)(this.box.volume() * 2));
    }

    public Box getVolume() {
        return this.box;
    }

    @Override
    public int getMinX() {
        return this.box.getMinX();
    }

    @Override
    public int getMinY() {
        return this.box.getMinY();
    }

    @Override
    public int getMinZ() {
        return this.box.getMinZ();
    }

    @Override
    public int getMaxX() {
        return this.box.getMaxX();
    }

    @Override
    public int getMaxY() {
        return this.box.getMaxY();
    }

    @Override
    public int getMaxZ() {
        return this.box.getMaxZ();
    }

    public boolean isInvalid() {
        return this.lightData == null;
    }

    protected void setBox(Box box) {
        this.box.assign(box);
    }

    public short getPackedLight(int x, int y, int z) {
        if (this.box.contains(x, y, z)) {
            return MemoryUtil.memGetShort((long)this.levelPosToPtr(x, y, z));
        }
        return 0;
    }

    public void move(Box newSampleVolume) {
        if (this.lightData == null) {
            return;
        }
        this.setBox(newSampleVolume);
        int neededCapacity = this.box.volume() * 2;
        if ((long)neededCapacity > this.lightData.size()) {
            this.lightData = this.lightData.realloc((long)neededCapacity);
        }
        this.initialize();
    }

    public void initialize() {
        if (this.lightData == null) {
            return;
        }
        this.copyLight(this.getVolume());
        this.markDirty();
    }

    protected void markDirty() {
    }

    public void delete() {
        this.lightData.free();
        this.lightData = null;
    }

    public void copyLight(Box levelVolume) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xShift = this.box.getMinX();
        int yShift = this.box.getMinY();
        int zShift = this.box.getMinZ();
        levelVolume.forEachContained((x, y, z) -> {
            pos.set(x, y, z);
            int block = this.level.getBrightness(LightLayer.BLOCK, (BlockPos)pos);
            int sky = this.level.getBrightness(LightLayer.SKY, (BlockPos)pos);
            this.writeLight(x - xShift, y - yShift, z - zShift, block, sky);
        });
    }

    protected void writeLight(int x, int y, int z, int block, int sky) {
        byte b = (byte)((block & 0xF) << 4);
        byte s = (byte)((sky & 0xF) << 4);
        long ptr = this.boxPosToPtr(x, y, z);
        MemoryUtil.memPutByte((long)ptr, (byte)b);
        MemoryUtil.memPutByte((long)(ptr + 1L), (byte)s);
    }

    public void copyBlock(Box levelVolume) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xShift = this.box.getMinX();
        int yShift = this.box.getMinY();
        int zShift = this.box.getMinZ();
        levelVolume.forEachContained((x, y, z) -> {
            int light = this.level.getBrightness(LightLayer.BLOCK, (BlockPos)pos.set(x, y, z));
            this.writeBlock(x - xShift, y - yShift, z - zShift, light);
        });
    }

    protected void writeBlock(int x, int y, int z, int block) {
        byte b = (byte)((block & 0xF) << 4);
        MemoryUtil.memPutByte((long)this.boxPosToPtr(x, y, z), (byte)b);
    }

    public void copySky(Box levelVolume) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xShift = this.box.getMinX();
        int yShift = this.box.getMinY();
        int zShift = this.box.getMinZ();
        levelVolume.forEachContained((x, y, z) -> {
            int light = this.level.getBrightness(LightLayer.SKY, (BlockPos)pos.set(x, y, z));
            this.writeSky(x - xShift, y - yShift, z - zShift, light);
        });
    }

    protected void writeSky(int x, int y, int z, int sky) {
        byte s = (byte)((sky & 0xF) << 4);
        MemoryUtil.memPutByte((long)(this.boxPosToPtr(x, y, z) + 1L), (byte)s);
    }

    protected long levelPosToPtr(int x, int y, int z) {
        return this.lightData.ptr() + (long)this.levelPosToPtrOffset(x, y, z);
    }

    protected long boxPosToPtr(int x, int y, int z) {
        return this.lightData.ptr() + (long)this.boxPosToPtrOffset(x, y, z);
    }

    protected int levelPosToPtrOffset(int x, int y, int z) {
        return this.boxPosToPtrOffset(x -= this.box.getMinX(), y -= this.box.getMinY(), z -= this.box.getMinZ());
    }

    protected int boxPosToPtrOffset(int x, int y, int z) {
        return (x + this.box.sizeX() * (y + z * this.box.sizeY())) * 2;
    }

    public void onLightUpdate(LightLayer type, SectionPos pos) {
        if (this.lightData == null) {
            return;
        }
        MutableBox vol = MutableBox.from(pos);
        if (!vol.intersects(this.getVolume())) {
            return;
        }
        vol.intersectAssign(this.getVolume());
        if (type == LightLayer.BLOCK) {
            this.copyBlock(vol);
        } else if (type == LightLayer.SKY) {
            this.copySky(vol);
        }
        this.markDirty();
    }
}

