/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.gui;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CookingPotTooltip
implements ClientTooltipComponent {
    private static final int ITEM_SIZE = 16;
    private static final int MARGIN = 4;
    private final int textSpacing;
    private final ItemStack mealStack;

    public CookingPotTooltip(CookingPotTooltipComponent tooltip) {
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.textSpacing = 9 + 1;
        this.mealStack = tooltip.mealStack;
    }

    public int getHeight() {
        return this.mealStack.isEmpty() ? this.textSpacing : this.textSpacing + 16;
    }

    public int getWidth(Font font) {
        if (!this.mealStack.isEmpty()) {
            MutableComponent textServingsOf = this.mealStack.getCount() == 1 ? TextUtils.getTranslation("tooltip.cooking_pot.single_serving", new Object[0]) : TextUtils.getTranslation("tooltip.cooking_pot.many_servings", this.mealStack.getCount());
            return Math.max(font.width((FormattedText)textServingsOf), font.width((FormattedText)this.mealStack.getHoverName()) + 20);
        }
        return font.width((FormattedText)TextUtils.getTranslation("tooltip.cooking_pot.empty", new Object[0]));
    }

    public void renderImage(Font font, int mouseX, int mouseY, GuiGraphics gui) {
        if (this.mealStack.isEmpty()) {
            return;
        }
        gui.renderItem(this.mealStack, mouseX, mouseY + this.textSpacing, 0);
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix4f, MultiBufferSource.BufferSource bufferSource) {
        int gray;
        Integer color = ChatFormatting.GRAY.getColor();
        int n = gray = color == null ? -1 : color;
        if (!this.mealStack.isEmpty()) {
            MutableComponent textServingsOf = this.mealStack.getCount() == 1 ? TextUtils.getTranslation("tooltip.cooking_pot.single_serving", new Object[0]) : TextUtils.getTranslation("tooltip.cooking_pot.many_servings", this.mealStack.getCount());
            font.drawInBatch((Component)textServingsOf, (float)x, (float)y, gray, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            font.drawInBatch(this.mealStack.getHoverName(), (float)(x + 16 + 4), (float)(y + this.textSpacing + 4), -1, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else {
            MutableComponent textEmpty = TextUtils.getTranslation("tooltip.cooking_pot.empty", new Object[0]);
            font.drawInBatch((Component)textEmpty, (float)x, (float)y, gray, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public record CookingPotTooltipComponent(ItemStack mealStack) implements TooltipComponent
    {
    }
}

